/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.wizard;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.data.ResolvedBookmark;
import nz.org.riskscape.engine.relation.Relation;
import nz.org.riskscape.engine.relation.TupleIterator;
import nz.org.riskscape.engine.types.Enumeration;
import nz.org.riskscape.engine.types.Floating;
import nz.org.riskscape.engine.types.Integer;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.Text;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.WithinSet;
import nz.org.riskscape.problem.ProblemSink;
import nz.org.riskscape.wizard.Choice;
import nz.org.riskscape.wizard.Question;
import nz.org.riskscape.wizard.bld.IncrementalBuildState;

public class ExpressionHelper {
    public static final String TAG_LAYER_QUESTION_NAME = "expression-helper-layer-question";
    public static final String TAG_LAYER_NAME = "expression-helper-feature-member";
    public static final String TAG_EXPRESSION_TYPE = "expression-helper-expression-type";
    public static final String TAG_EXPRESSION_TYPE_BOOLEAN = "boolean";
    public static final String TAG_EXPRESSION_TYPE_NUMERIC = "numeric";
    private final Question question;
    private final Struct context;
    private final Optional<Relation> relation;

    public static Optional<ExpressionHelper> create(IncrementalBuildState buildState, Question question) {
        Optional<String> layerQuestion = question.getAnnotation(TAG_LAYER_QUESTION_NAME);
        if (layerQuestion.isPresent()) {
            ResolvedBookmark bookmark = layerQuestion.map(name -> buildState.getAnswerTo(buildState.getQuestionSet().getId(), (String)name, ResolvedBookmark.class)).orElse(null);
            Optional<String> layerName = question.getAnnotation(TAG_LAYER_NAME);
            if (bookmark != null) {
                if (layerName.isPresent()) {
                    return (Optional)bookmark.getData(Relation.class).map(relation -> Optional.of(new ExpressionHelper(question, (Relation)relation, (String)layerName.get()))).orElse(Optional.empty());
                }
                return (Optional)bookmark.getData(Relation.class).map(relation -> Optional.of(new ExpressionHelper(question, (Relation)relation))).orElse(Optional.empty());
            }
        }
        return Optional.of(new ExpressionHelper(question, buildState.getInputStruct(question)));
    }

    public ExpressionHelper(Question question, Struct context) {
        this.question = question;
        this.context = context;
        this.relation = Optional.empty();
    }

    ExpressionHelper(Question question, Relation relation, String layerName) {
        this.question = question;
        this.context = Struct.of((String)layerName, (Type)relation.getType());
        this.relation = Optional.of(relation);
    }

    ExpressionHelper(Question question, Relation relation) {
        this.question = question;
        this.context = relation.getType();
        this.relation = Optional.of(relation);
    }

    public List<AttributeMetadata> getAttributeMetadata(List<Class<? extends Type>> allowedTypes) {
        ArrayList<AttributeMetadata> attributes = new ArrayList<AttributeMetadata>();
        this.findAllAttributes(this.context, Collections.emptyList(), attr -> attributes.add((AttributeMetadata)attr));
        if (allowedTypes == null || allowedTypes.isEmpty()) {
            return attributes;
        }
        return attributes.stream().filter(attr -> attr.oneOf(allowedTypes)).collect(Collectors.toList());
    }

    public List<AttributeMetadata> getAttributeMetadata() {
        return this.getAttributeMetadata(Collections.emptyList());
    }

    private void findAllAttributes(Struct currentContext, List<Struct.StructMember> parents, Consumer<AttributeMetadata> attributeComsumer) {
        for (Struct.StructMember member : currentContext.getMembers()) {
            ArrayList pathList = Lists.newArrayList(parents);
            pathList.add(member);
            Optional isStruct = member.getType().findAllowNull(Struct.class);
            if (isStruct.isPresent()) {
                this.findAllAttributes((Struct)isStruct.get(), pathList, attributeComsumer);
                attributeComsumer.accept(new AttributeMetadata(pathList));
                continue;
            }
            attributeComsumer.accept(new AttributeMetadata(pathList));
        }
    }

    public List<AttributeValue> getValues(@NonNull AttributeMetadata attribute) {
        if (attribute == null) {
            throw new NullPointerException("attribute is marked non-null but is null");
        }
        List<AttributeValue> values = this.doGetValues(attribute);
        Collections.sort(values);
        return values;
    }

    private List<AttributeValue> doGetValues(@NonNull AttributeMetadata attribute) {
        if (attribute == null) {
            throw new NullPointerException("attribute is marked non-null but is null");
        }
        if (attribute.isA(WithinSet.class)) {
            return this.valuesFrom((WithinSet)attribute.getType().find(WithinSet.class).get());
        }
        if (attribute.isA(Enumeration.class)) {
            return this.valuesFrom((Enumeration)attribute.getType().find(Enumeration.class).get());
        }
        if (!this.relation.isPresent()) {
            return Collections.emptyList();
        }
        ArrayList<Comparable> foundValues = new ArrayList<Comparable>();
        TupleIterator it = this.relation.get().skipInvalid(ProblemSink.DEVNULL).iterator();
        while (it.hasNext()) {
            Tuple t = (Tuple)it.next();
            Comparable value2 = (Comparable)t.fetch(attribute.getMember());
            if (foundValues.contains(value2)) continue;
            foundValues.add(value2);
        }
        it.close();
        return foundValues.stream().map(value -> new AttributeValue((Comparable)value)).collect(Collectors.toList());
    }

    private List<AttributeValue> valuesFrom(WithinSet set) {
        return set.getAllowed().stream().map(allowed -> new AttributeValue((Comparable)((Object)allowed.toString()))).collect(Collectors.toList());
    }

    private List<AttributeValue> valuesFrom(Enumeration enumeration) {
        return Arrays.stream(enumeration.getValues()).map(value -> new AttributeValue((Comparable)((Object)value), (String)value)).collect(Collectors.toList());
    }

    public Optional<String> getExpressionType() {
        return this.question.getAnnotation(TAG_EXPRESSION_TYPE);
    }

    public List<Choice> getAttributeChoices() {
        List<Class<? extends Type>> allowedTypes = Collections.emptyList();
        if (this.question.hasAnnotationWithValue("attribute", TAG_EXPRESSION_TYPE_NUMERIC)) {
            allowedTypes = List.of(Integer.class, Floating.class);
        } else if (this.question.hasAnnotationWithValue("attribute", "comparable")) {
            allowedTypes = List.of(Text.class, Integer.class, Floating.class, Enumeration.class);
        }
        return this.getAttributeMetadata(allowedTypes).stream().map(attr -> new Choice(attr.getFullyQualifiedName(), attr.getFullyQualifiedName(), Optional.empty(), attr)).collect(Collectors.toList());
    }

    @Generated
    public Question getQuestion() {
        return this.question;
    }

    @Generated
    public Struct getContext() {
        return this.context;
    }

    public static class AttributeMetadata {
        private final List<Struct.StructMember> memberHierarchy;

        public String getName() {
            return this.getMember().getKey();
        }

        public String getFullyQualifiedName() {
            return this.memberHierarchy.stream().map(Struct.StructMember::getKey).collect(Collectors.joining("."));
        }

        private Struct.StructMember getMember() {
            return this.memberHierarchy.get(this.memberHierarchy.size() - 1);
        }

        public Type getType() {
            return this.getMember().getType();
        }

        private boolean isA(Class<? extends Type> type) {
            return this.getType().findAllowNull(type).isPresent();
        }

        private boolean oneOf(List<Class<? extends Type>> types) {
            for (Class<? extends Type> type : types) {
                if (!this.isA(type)) continue;
                return true;
            }
            return false;
        }

        @Generated
        public AttributeMetadata(List<Struct.StructMember> memberHierarchy) {
            this.memberHierarchy = memberHierarchy;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AttributeMetadata)) {
                return false;
            }
            AttributeMetadata other = (AttributeMetadata)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<Struct.StructMember> this$memberHierarchy = this.memberHierarchy;
            List<Struct.StructMember> other$memberHierarchy = other.memberHierarchy;
            return !(this$memberHierarchy == null ? other$memberHierarchy != null : !((Object)this$memberHierarchy).equals(other$memberHierarchy));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AttributeMetadata;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<Struct.StructMember> $memberHierarchy = this.memberHierarchy;
            result = result * 59 + ($memberHierarchy == null ? 43 : ((Object)$memberHierarchy).hashCode());
            return result;
        }
    }

    public static class AttributeValue
    implements Comparable<AttributeValue> {
        private final Comparable value;
        private final String label;

        AttributeValue(Comparable value) {
            this.value = value;
            this.label = value.toString();
        }

        @Override
        public int compareTo(AttributeValue other) {
            return this.value.compareTo(other.value);
        }

        @Generated
        public Comparable getValue() {
            return this.value;
        }

        @Generated
        public String getLabel() {
            return this.label;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AttributeValue)) {
                return false;
            }
            AttributeValue other = (AttributeValue)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Comparable this$value = this.getValue();
            Comparable other$value = other.getValue();
            if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
                return false;
            }
            String this$label = this.getLabel();
            String other$label = other.getLabel();
            return !(this$label == null ? other$label != null : !this$label.equals(other$label));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AttributeValue;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Comparable $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            String $label = this.getLabel();
            result = result * 59 + ($label == null ? 43 : $label.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ExpressionHelper.AttributeValue(value=" + String.valueOf(this.getValue()) + ", label=" + this.getLabel() + ")";
        }

        @Generated
        AttributeValue(Comparable value, String label) {
            this.value = value;
            this.label = label;
        }
    }
}

