/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.wizard;

import com.google.common.collect.Range;
import com.google.common.collect.Streams;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import lombok.Generated;
import nz.org.riskscape.engine.bind.ParamProblems;
import nz.org.riskscape.engine.bind.Parameter;
import nz.org.riskscape.engine.pipeline.ExecutionContext;
import nz.org.riskscape.engine.problem.ProblemFactory;
import nz.org.riskscape.engine.problem.SeverityLevel;
import nz.org.riskscape.engine.util.Pair;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ProblemException;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;
import nz.org.riskscape.wizard.Answer;
import nz.org.riskscape.wizard.Question;
import nz.org.riskscape.wizard.QuestionSet;
import nz.org.riskscape.wizard.Survey;
import nz.org.riskscape.wizard.WizardModelParameter;
import nz.org.riskscape.wizard.WizardProblems;
import nz.org.riskscape.wizard.WizardProcessor;
import nz.org.riskscape.wizard.bld.IncrementalBuildState;
import nz.org.riskscape.wizard.survey2.PickQuestionSet;

public class ConfigParser {
    private static final String SURVEY_VERSION_TAG = "-wizard-v";
    private static final String SURVEY_ID_KEY = "survey";
    private final Function<String, Survey> surveyConstructor;
    public static final LocalProblems PROBLEMS = (LocalProblems)Problems.get(LocalProblems.class);
    private static final String VERSION_KEY = "version";

    public static String appendComponent(String prefix, Object subkey) {
        String subkeyString = subkey.toString();
        return new StringBuilder(prefix.length() + subkeyString.length() + 2).append(prefix).append('[').append(subkeyString).append(']').toString();
    }

    private Optional<String> extractNextComponent(String key, String prefix) {
        int endIndex;
        if (key.startsWith(prefix + "[") && (endIndex = key.indexOf(93, prefix.length())) != -1) {
            return Optional.of(key.substring(prefix.length() + 1, endIndex));
        }
        return Optional.empty();
    }

    public ResultOrProblems<IncrementalBuildState> loadConfig(ExecutionContext context, Map<String, List<?>> configToLoad) {
        Survey survey = this.getSurvey(configToLoad);
        configToLoad.remove(VERSION_KEY);
        return this.loadConfig2(survey, context, configToLoad);
    }

    Survey getSurvey(Map<String, List<?>> configToLoad) {
        List<?> config = configToLoad.remove(SURVEY_ID_KEY);
        String id = config == null || config.isEmpty() ? "model" : config.get(0).toString();
        return this.surveyConstructor.apply(id);
    }

    private boolean hasAnswersToQuestionSet(Map<String, List<?>> configToLoad, String questionSetId) {
        for (String key : configToLoad.keySet()) {
            if (!key.startsWith(questionSetId + ".")) continue;
            return true;
        }
        return false;
    }

    private List<String> peekQuestionSet(WizardProcessor processor, Question question, Map<String, List<?>> configToLoad) {
        Survey survey = question.getSurvey();
        if (survey.isQuestionSetReplayOrdered()) {
            return null;
        }
        List<PickQuestionSet> choiceList = question.getChoices(processor.getBuildState()).stream().map(choice -> choice.getDerivedFrom(PickQuestionSet.class)).toList();
        for (PickQuestionSet choice2 : choiceList) {
            if (!this.hasAnswersToQuestionSet(configToLoad, choice2.getQuestionSetId())) continue;
            return Arrays.asList(choice2.getQuestionSetId());
        }
        for (PickQuestionSet choice2 : choiceList) {
            if (!choice2.isSkip()) continue;
            return Arrays.asList(choice2.getQuestionSetId());
        }
        return null;
    }

    public ResultOrProblems<IncrementalBuildState> loadConfig2(Survey survey, ExecutionContext context, Map<String, List<?>> configToLoad) {
        WizardProcessor processor = new WizardProcessor(context, survey);
        LinkedList<Problem> problems = new LinkedList<Problem>();
        configToLoad = new LinkedHashMap(configToLoad);
        while (!processor.isDone()) {
            List<Question> availableQuestions = processor.getNextQuestions();
            Question question = availableQuestions.get(0);
            try {
                Object response = this.deserializeResponse(configToLoad, question.getId(), question.getArity());
                List<Object> responses = response == null && question.getParameterType().equals(PickQuestionSet.class) ? this.peekQuestionSet(processor, question, configToLoad) : (response == null || response instanceof List ? (List<String>)response : Arrays.asList(response));
                if (responses != null) {
                    Answer answer = (Answer)Answer.bindAll(processor.getBindingContext(), question, responses).drainWarnings(p -> problems.add((Problem)p), (severity, warnings) -> Problems.foundWith((Object)question.toParameter(), (List)warnings)).getOrThrow(probs -> WizardProblems.get().configError().withChildren(new Problems[]{this.problemWith(question).withChildren(new Problems[]{probs})}));
                    processor.applyAnswer(answer);
                } else {
                    if (question.isRequired() && !question.isHidden()) {
                        if (!survey.isFinished(processor.getBuildState())) {
                            problems.add(PROBLEMS.unfinishedSurvey(question.getId()));
                        }
                        break;
                    }
                    processor.skip(question);
                }
                if (!processor.isFailed()) continue;
                return ResultOrProblems.failed(this.configError(PROBLEMS.couldNotApplyChange(question.toParameter()).withChildren(processor.getFailures())), (ResultOrProblems[])new ResultOrProblems[0]);
            }
            catch (ProblemException e) {
                return e.toResult();
            }
        }
        if (!configToLoad.keySet().isEmpty()) {
            problems.add(ParamProblems.get().ignored(configToLoad.keySet().toString()).withChildren(new Problems[]{PROBLEMS.ignoredParamsTip()}));
        }
        return ResultOrProblems.of((Object)processor.getBuildState(), problems);
    }

    Object deserializeResponse(Map<String, List<?>> configToLoad, String prefix) throws ProblemException {
        return this.deserializeResponse(configToLoad, prefix, Optional.empty());
    }

    private Object deserializeResponse(Map<String, List<?>> configToLoad, String prefix, Range<Integer> arity) throws ProblemException {
        return this.deserializeResponse(configToLoad, prefix, Optional.of(arity));
    }

    Object deserializeResponse(Map<String, List<?>> configToLoad, String prefix, Optional<Range<Integer>> arity) throws ProblemException {
        boolean isSingleValued = arity.map(range -> range.hasUpperBound() && (Integer)range.upperEndpoint() <= 1).orElse(false);
        List<?> exactMatch = configToLoad.remove(prefix);
        Set<String> subkeys = this.getSubkeys(prefix, configToLoad);
        if (exactMatch != null) {
            if (exactMatch.size() == 1) {
                if (subkeys.size() > 0) {
                    String originalKeys = subkeys.stream().map(key -> prefix + "[" + key + "]").collect(Collectors.joining(", "));
                    throw new ProblemException((Problems)WizardProblems.get().configError().withChildren(new Problems[]{PROBLEMS.mixedSubKeys(prefix, originalKeys)}));
                }
                return exactMatch.get(0);
            }
            if (isSingleValued) {
                throw new ProblemException((Problems)WizardProblems.get().configError().withChildren(new Problems[]{ParamProblems.get().wrongNumberGiven(prefix, arity.get().toString(), exactMatch.size())}));
            }
            throw new ProblemException((Problems)WizardProblems.get().configError().withChildren(new Problems[]{PROBLEMS.multipleKeysGiven(prefix)}));
        }
        if (subkeys.isEmpty()) {
            return null;
        }
        List indices = subkeys.stream().map(str -> {
            try {
                return Optional.of(Integer.parseInt(str));
            }
            catch (NumberFormatException e) {
                return Optional.empty();
            }
        }).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        if (subkeys.size() == indices.size()) {
            if (isSingleValued) {
                throw new ProblemException((Problems)WizardProblems.get().configError().withChildren(new Problems[]{ParamProblems.get().wrongNumberGiven(prefix, arity.get().toString(), indices.size())}));
            }
            ArrayList<Object> subResponses = new ArrayList<Object>(indices.size());
            for (int i = 0; i < indices.size(); ++i) {
                Object subResponse = this.deserializeResponse(configToLoad, ConfigParser.appendComponent(prefix, i));
                if (subResponse == null) {
                    throw new ProblemException((Problems)WizardProblems.get().configError().withChildren(new Problems[]{PROBLEMS.indicesNotContiguous(prefix, i)}));
                }
                subResponses.add(subResponse);
            }
            return subResponses;
        }
        HashMap<String, Object> mappedResponses = new HashMap<String, Object>(subkeys.size());
        for (String subkey : subkeys) {
            mappedResponses.put(subkey, this.deserializeResponse(configToLoad, ConfigParser.appendComponent(prefix, subkey)));
        }
        return mappedResponses;
    }

    private Set<String> getSubkeys(String prefix, Map<String, List<?>> configToLoad) {
        return configToLoad.keySet().stream().map(key -> this.extractNextComponent((String)key, prefix)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
    }

    private boolean hasConfig(Question question) {
        if (question.isHidden()) {
            return false;
        }
        return !question.getParameterType().equals(PickQuestionSet.class) || question.getSurvey().isQuestionSetReplayOrdered();
    }

    public List<WizardModelParameter> getModelParameters(IncrementalBuildState buildState) {
        List orderedIbs = buildState.buildStateStream().filter(ibs -> this.hasConfig(ibs.getQuestion())).collect(Collectors.toList());
        Collections.reverse(orderedIbs);
        return orderedIbs.stream().flatMap(ibs -> {
            Answer answer = ibs.getAnswer();
            Question question = answer.getQuestion();
            if (question.isSingleValueQuestion() && !answer.isEmpty()) {
                return this.toModelParameters(question.getId(), (IncrementalBuildState)ibs, question, answer.getOriginalResponses().get(0));
            }
            return IntStream.range(0, answer.getOriginalResponses().size()).mapToObj(Integer::valueOf).flatMap(index -> {
                Object response = answer.getOriginalResponses().get((int)index);
                return this.toModelParameters(ConfigParser.appendComponent(question.getId(), index), (IncrementalBuildState)ibs, question, response);
            });
        }).collect(Collectors.toList());
    }

    public Stream<Pair<String, String>> getConfigToWrite(IncrementalBuildState buildState) {
        Stream<Pair> answerPairs = this.getModelParameters(buildState).stream().map(mp -> Pair.of((Object)mp.getName(), (Object)this.getDefaultValue((WizardModelParameter)((Object)mp), buildState)));
        return Streams.concat((Stream[])new Stream[]{Arrays.asList(Pair.of((Object)VERSION_KEY, (Object)this.getVersion(buildState))).stream(), answerPairs});
    }

    private String getDefaultValue(WizardModelParameter param, IncrementalBuildState buildState) {
        List defaults = param.getParameter().getDefaultValues(buildState.getBindingContext());
        return defaults.get(0).toString();
    }

    public String getVersion(IncrementalBuildState buildState) {
        String engineId = buildState.getProject().getEngine().getBuildInfo().getVersion();
        String surveyVersion = SURVEY_VERSION_TAG + Integer.toString(buildState.getSurvey().getVersion());
        return engineId + surveyVersion;
    }

    int parseSurveyVersion(String versionString) {
        String[] parts = versionString.split(SURVEY_VERSION_TAG);
        if (parts.length == 2) {
            try {
                return Integer.parseInt(parts[1]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0;
    }

    private Stream<WizardModelParameter> toModelParameters(String prefix, IncrementalBuildState buildState, Question question, Object toSerialize) {
        if (toSerialize instanceof Map) {
            Map map = (Map)toSerialize;
            return map.entrySet().stream().flatMap(entry -> {
                Question subQuestion = question.getSubQuestion(entry.getKey().toString()).orElse(question);
                return this.toModelParameters(ConfigParser.appendComponent(prefix, entry.getKey()), buildState, subQuestion, entry.getValue());
            });
        }
        if (toSerialize instanceof List) {
            List list = (List)toSerialize;
            return IntStream.range(0, list.size()).mapToObj(i -> i).flatMap(i -> this.toModelParameters(ConfigParser.appendComponent(prefix, i), buildState, question, list.get((int)i)));
        }
        Parameter param = Parameter.required((String)prefix, String.class).withNewDefaults((bc, p) -> Arrays.asList(toSerialize.toString()));
        IncrementalBuildState inputBuildState = buildState.getLast();
        return Collections.singletonList(new WizardModelParameter(param, question, inputBuildState)).stream();
    }

    private ResultOrProblems<IncrementalBuildState> configError(Problem reason) {
        return ResultOrProblems.failed((Problem[])new Problem[]{WizardProblems.get().configError().withChildren(new Problems[]{reason})});
    }

    private Problem problemWith(Question question) {
        if (question.isHidden()) {
            return Problems.foundWith(QuestionSet.class, (String)question.getQuestionSet().getId(), (Problem[])new Problem[0]);
        }
        return Problems.foundWith((Object)question.toParameter(), (Problem[])new Problem[0]);
    }

    private IncrementalBuildState getOrThrow(ResultOrProblems<IncrementalBuildState> newBuildStateOr, Object affectedParams) throws ProblemException {
        if (newBuildStateOr.hasErrors()) {
            this.configError(PROBLEMS.couldNotApplyChange(affectedParams).withChildren(newBuildStateOr.getProblems())).getOrThrow();
        }
        return (IncrementalBuildState)newBuildStateOr.get();
    }

    @Generated
    public ConfigParser(Function<String, Survey> surveyConstructor) {
        this.surveyConstructor = surveyConstructor;
    }

    public static interface LocalProblems
    extends ProblemFactory {
        public Problem couldNotApplyChange(Object var1);

        public Problem indicesNotContiguous(String var1, int var2);

        public Problem multipleKeysGiven(String var1);

        public Problem mixedSubKeys(String var1, String var2);

        @SeverityLevel(value=Problem.Severity.WARNING)
        public Problem ignoredParamsTip();

        @SeverityLevel(value=Problem.Severity.WARNING)
        public Problem unfinishedSurvey(String var1);
    }
}

