/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.wizard;

import java.util.Locale;
import java.util.Optional;
import lombok.Generated;
import nz.org.riskscape.wizard.QuestionSet;
import nz.org.riskscape.wizard.Survey;

public abstract class BaseQuestionSet
implements QuestionSet {
    protected final String name;
    protected final String discriminator;
    protected final String id;
    protected final Survey survey;

    public BaseQuestionSet(String id, Survey survey) {
        this.id = id;
        this.survey = survey;
        this.discriminator = null;
        this.name = id;
    }

    public BaseQuestionSet(String name, String discriminator, Survey survey) {
        this.id = name + "-" + discriminator;
        this.survey = survey;
        this.discriminator = discriminator;
        this.name = name;
    }

    private String getI18nMessage(String key, Locale locale, Object ... args) {
        String i18nMsg = null;
        if (this.discriminator != null) {
            i18nMsg = this.getSurvey().getMessageSource().getMessage(key + "." + this.discriminator, args, locale);
        }
        if (i18nMsg == null) {
            i18nMsg = this.getSurvey().getMessageSource().getMessage(key, args, locale);
        }
        return i18nMsg;
    }

    @Override
    public Optional<String> getDescription(Locale locale) {
        return Optional.ofNullable(this.getI18nMessage("set." + this.name + ".description", locale, this.discriminator));
    }

    @Override
    public Optional<String> getTitle(Locale locale) {
        return Optional.ofNullable(this.getI18nMessage("set." + this.name + ".title", locale, this.discriminator));
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseQuestionSet)) {
            return false;
        }
        BaseQuestionSet other = (BaseQuestionSet)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Survey this$survey = this.getSurvey();
        Survey other$survey = other.getSurvey();
        return !(this$survey == null ? other$survey != null : !this$survey.equals(other$survey));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BaseQuestionSet;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        Survey $survey = this.getSurvey();
        result = result * 59 + ($survey == null ? 43 : $survey.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getName() {
        return this.name;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Override
    @Generated
    public Survey getSurvey() {
        return this.survey;
    }
}

