/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.wizard;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import nz.org.riskscape.engine.bind.BindingContext;
import nz.org.riskscape.engine.bind.Parameter;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ResultOrProblems;
import nz.org.riskscape.wizard.Question;
import nz.org.riskscape.wizard.QuestionSet;

public class Answer {
    private final Question question;
    private final List<Response> responses;

    public static ResultOrProblems<Response> bind(BindingContext context, Question chosen, Object input) {
        return context.bind(input, chosen.getParameterType()).map(bound -> new Response(bound, input));
    }

    public static ResultOrProblems<Answer> bindAll(BindingContext context, Question question, List<?> responses) {
        LinkedList problems = new LinkedList();
        ArrayList<Response> successfulResponses = new ArrayList<Response>(responses.size());
        for (Object response : responses) {
            ResultOrProblems<Response> boundResponse = Answer.bind(context, question, response);
            if (boundResponse.isPresent()) {
                successfulResponses.add((Response)boundResponse.drainWarnings(p -> problems.add(p)).get());
                continue;
            }
            boundResponse.addProblemsTo(problems);
        }
        if (Problem.hasErrors(problems)) {
            return ResultOrProblems.failed(problems);
        }
        return ResultOrProblems.of((Object)new Answer(question, successfulResponses), problems);
    }

    public static Answer strings(Question answered, String ... valuesAndResponses) {
        return new Answer(answered, Arrays.asList(valuesAndResponses).stream().map(str -> new Response(str, str)).collect(Collectors.toList()));
    }

    public static Answer single(Question answered, Object boundValue, Object response) {
        return new Answer(answered, Collections.singletonList(new Response(boundValue, response)));
    }

    public static Answer hidden(Question answered) {
        if (!answered.isHidden()) {
            throw new IllegalArgumentException("attempted to create a hidden answer from a question that's not hidden - " + String.valueOf(answered));
        }
        return Answer.single(answered, Question.HIDDEN_VALUE, Collections.EMPTY_LIST);
    }

    public static Answer skip(Question notAnswered) {
        return new Answer(notAnswered, Collections.emptyList());
    }

    public Answer(Question answered, Response ... responses) {
        this(answered, Arrays.asList(responses));
    }

    public Answer(@NonNull Question answered, @NonNull List<Response> values) {
        if (answered == null) {
            throw new NullPointerException("answered is marked non-null but is null");
        }
        if (values == null) {
            throw new NullPointerException("values is marked non-null but is null");
        }
        this.question = answered;
        this.responses = values;
        answered.checkValidity(this.getValues());
    }

    public List<Object> getValues() {
        return Lists.transform(this.responses, resp -> resp.getBoundValue());
    }

    public <T> List<T> getValuesAs(Class<T> asClass) {
        if (!asClass.isAssignableFrom(this.question.getParameterType())) {
            throw new IllegalArgumentException("given class " + String.valueOf(asClass) + " does not match question " + String.valueOf(this.question));
        }
        ArrayList values = new ArrayList(this.responses.size());
        this.responses.forEach(resp -> {
            Object boundValue = resp.getBoundValue();
            if (!asClass.isAssignableFrom(boundValue.getClass())) {
                throw new AssertionError((Object)("some how an invariant response type has crept in - " + String.valueOf(boundValue.getClass())));
            }
            values.add(asClass.cast(boundValue));
        });
        return values;
    }

    public <T> T getValueAs(Class<T> asClass) {
        this.question.requireSingleValueQuestion();
        List<T> values = this.getValuesAs(asClass);
        return values.size() > 0 ? (T)values.get(0) : null;
    }

    public Response getResponse() {
        this.question.requireSingleValueQuestion();
        if (this.responses.isEmpty()) {
            return null;
        }
        return this.responses.get(0);
    }

    public List<Response> getResponses() {
        return new ArrayList<Response>(this.responses);
    }

    public List<Object> getOriginalResponses() {
        return this.responses.stream().map(Response::getOriginalInput).collect(Collectors.toList());
    }

    public boolean isSameQuestion(Question rhsQuestion) {
        return this.getQuestion().equals(rhsQuestion);
    }

    public String getId() {
        return this.question.getId();
    }

    public QuestionSet getQuestionSet() {
        return this.question.getQuestionSet();
    }

    public String toString() {
        return String.format("Answer[to=%s, responses=%s]", this.getId(), this.responses.stream().map(r -> r.getOriginalInput().toString()).collect(Collectors.joining(",")));
    }

    public Parameter toParameter() {
        return this.question.toParameter().withNewDefaults((c, p) -> this.getValues());
    }

    public boolean isEmpty() {
        return this.responses.isEmpty();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Answer)) {
            return false;
        }
        Answer other = (Answer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Question this$question = this.getQuestion();
        Question other$question = other.getQuestion();
        if (this$question == null ? other$question != null : !((Object)this$question).equals(other$question)) {
            return false;
        }
        List<Response> this$responses = this.getResponses();
        List<Response> other$responses = other.getResponses();
        return !(this$responses == null ? other$responses != null : !((Object)this$responses).equals(other$responses));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Answer;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Question $question = this.getQuestion();
        result = result * 59 + ($question == null ? 43 : ((Object)$question).hashCode());
        List<Response> $responses = this.getResponses();
        result = result * 59 + ($responses == null ? 43 : ((Object)$responses).hashCode());
        return result;
    }

    @Generated
    public Question getQuestion() {
        return this.question;
    }

    public static final class Response {
        private final Object boundValue;
        private final Object originalInput;

        @Generated
        public Response(Object boundValue, Object originalInput) {
            this.boundValue = boundValue;
            this.originalInput = originalInput;
        }

        @Generated
        public Object getBoundValue() {
            return this.boundValue;
        }

        @Generated
        public Object getOriginalInput() {
            return this.originalInput;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Response)) {
                return false;
            }
            Response other = (Response)o;
            Object this$boundValue = this.getBoundValue();
            Object other$boundValue = other.getBoundValue();
            if (this$boundValue == null ? other$boundValue != null : !this$boundValue.equals(other$boundValue)) {
                return false;
            }
            Object this$originalInput = this.getOriginalInput();
            Object other$originalInput = other.getOriginalInput();
            return !(this$originalInput == null ? other$originalInput != null : !this$originalInput.equals(other$originalInput));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Object $boundValue = this.getBoundValue();
            result = result * 59 + ($boundValue == null ? 43 : $boundValue.hashCode());
            Object $originalInput = this.getOriginalInput();
            result = result * 59 + ($originalInput == null ? 43 : $originalInput.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Answer.Response(boundValue=" + String.valueOf(this.getBoundValue()) + ", originalInput=" + String.valueOf(this.getOriginalInput()) + ")";
        }
    }
}

