/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.octavia.internal;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import org.openstack4j.api.octavia.ListenerV2Service;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.octavia.ListenerV2;
import org.openstack4j.model.octavia.ListenerV2Update;
import org.openstack4j.openstack.compute.functions.ToActionResponseFunction;
import org.openstack4j.openstack.internal.BaseOpenStackService;
import org.openstack4j.openstack.octavia.domain.OctaviaListenerV2;
import org.openstack4j.openstack.octavia.internal.BaseOctaviaServices;

public class ListenerV2ServiceImpl
extends BaseOctaviaServices
implements ListenerV2Service {
    @Override
    public List<? extends ListenerV2> list() {
        return this.get(OctaviaListenerV2.Listeners.class, this.uri("/lbaas/listeners", new Object[0])).execute().getList();
    }

    @Override
    public List<? extends ListenerV2> list(Map<String, String> filteringParams) {
        BaseOpenStackService.Invocation<OctaviaListenerV2.Listeners> req = this.get(OctaviaListenerV2.Listeners.class, this.uri("/lbaas/listeners", new Object[0]));
        if (filteringParams != null) {
            for (Map.Entry<String, String> entry : filteringParams.entrySet()) {
                req = req.param(entry.getKey(), entry.getValue());
            }
        }
        return req.execute().getList();
    }

    @Override
    public ListenerV2 get(String listenerId) {
        Preconditions.checkNotNull((Object)listenerId);
        return this.get(OctaviaListenerV2.class, this.uri("/lbaas/listeners/%s", listenerId)).execute();
    }

    @Override
    public ActionResponse delete(String listenerId) {
        Preconditions.checkNotNull((Object)listenerId);
        return ToActionResponseFunction.INSTANCE.apply(this.delete(Void.class, this.uri("/lbaas/listeners/%s", listenerId)).executeWithResponse());
    }

    @Override
    public ListenerV2 create(ListenerV2 listener) {
        Preconditions.checkNotNull((Object)listener);
        return this.post(OctaviaListenerV2.class, this.uri("/lbaas/listeners", new Object[0])).entity(listener).execute();
    }

    @Override
    public ListenerV2 update(String listenerId, ListenerV2Update listener) {
        Preconditions.checkNotNull((Object)listenerId);
        Preconditions.checkNotNull((Object)listener);
        return this.put(OctaviaListenerV2.class, this.uri("/lbaas/listeners/%s", listenerId)).entity(listener).execute();
    }
}

