/*
 * Decompiled with CFR 0.152.
 */
package com.opencsv.validators;

import com.opencsv.exceptions.CsvValidationException;
import com.opencsv.validators.LineValidator;
import java.util.ArrayList;
import java.util.List;

public class LineValidatorAggregator {
    private static final int CAPACITY = 256;
    private List<LineValidator> validators = new ArrayList<LineValidator>();

    public void addValidator(LineValidator validator) {
        if (validator != null) {
            this.validators.add(validator);
        }
    }

    public boolean isValid(String line) {
        for (LineValidator validator : this.validators) {
            if (validator.isValid(line)) continue;
            return false;
        }
        return true;
    }

    public void validate(String line) throws CsvValidationException {
        StringBuilder combinedExceptionMessage = new StringBuilder(256);
        for (LineValidator validator : this.validators) {
            try {
                validator.validate(line);
            }
            catch (CsvValidationException ex) {
                combinedExceptionMessage.append(ex.getMessage()).append("\n");
            }
        }
        if (combinedExceptionMessage.length() > 0) {
            throw new CsvValidationException(combinedExceptionMessage.toString());
        }
    }
}

