/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.netcdf;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import nz.org.riskscape.engine.RiskscapeException;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.problem.GeneralProblems;
import nz.org.riskscape.engine.problem.ProblemFactory;
import nz.org.riskscape.engine.relation.BaseRelation;
import nz.org.riskscape.engine.relation.Relation;
import nz.org.riskscape.engine.relation.TupleIterator;
import nz.org.riskscape.engine.types.Integer;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.Types;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;
import ucar.ma2.Array;
import ucar.nc2.CDMNode;
import ucar.nc2.Dimension;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;

public class NetCdfRelation
extends BaseRelation {
    static final LocalProblems PROBLEMS = (LocalProblems)Problems.get(LocalProblems.class);
    private final NetcdfDataset ncd;
    private final List<Dimension> dimensions;
    private final List<Variable> variables;

    public static ResultOrProblems<Relation> of(NetcdfDataset ncd, List<String> layers) {
        ArrayList<Variable> collectedVariables = new ArrayList<Variable>();
        List collectedDimensions = null;
        for (String layer : layers) {
            ImmutableList varDimensions;
            Variable var = ncd.findVariable(layer);
            if (var != null) {
                varDimensions = var.getDimensions();
                if (varDimensions.size() != 1 || !((Dimension)varDimensions.get(0)).getShortName().equals(var.getShortName())) {
                    collectedVariables.add(var);
                }
            } else {
                List available = ncd.getVariables().stream().map(CDMNode::getShortName).collect(Collectors.toList());
                return ResultOrProblems.failed((Problem[])new Problem[]{GeneralProblems.get().notAnOption(layer, (Object)"layer", available)});
            }
            if (collectedDimensions == null) {
                collectedDimensions = varDimensions;
                continue;
            }
            if (collectedDimensions.equals(varDimensions)) continue;
            List<String> requiredDims = collectedDimensions.stream().map(Dimension::getShortName).collect(Collectors.toList());
            List<String> receivedDims = varDimensions.stream().map(Dimension::getShortName).collect(Collectors.toList());
            return ResultOrProblems.failed((Problem[])new Problem[]{PROBLEMS.mismatch(layer, requiredDims, receivedDims)});
        }
        Struct.StructBuilder sb = Struct.builder();
        for (Dimension dimension : collectedDimensions) {
            Variable dimVariable = ncd.findVariable(dimension.getShortName());
            Integer type = Types.INTEGER;
            if (dimVariable != null) {
                type = Types.fromJavaType((Class)dimVariable.getDataType().getPrimitiveClassType());
            }
            sb.add(dimension.getShortName(), (Type)type);
        }
        for (Variable variable : collectedVariables) {
            Type type = Types.fromJavaType((Class)variable.getDataType().getPrimitiveClassType());
            sb.add(variable.getShortName(), type);
        }
        return ResultOrProblems.of((Object)((Object)new NetCdfRelation(ncd, collectedVariables, (List<Dimension>)collectedDimensions, sb.build())));
    }

    private NetCdfRelation(NetcdfDataset ncd, List<Variable> variables, List<Dimension> dimensions, Struct produced) {
        super(produced);
        this.ncd = ncd;
        this.variables = variables;
        this.dimensions = dimensions;
    }

    private NetCdfRelation(NetcdfDataset ncd, List<Variable> variables, List<Dimension> dimensions, BaseRelation.Fields fields) {
        super(fields);
        this.ncd = ncd;
        this.variables = variables;
        this.dimensions = dimensions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TupleIterator rawIterator() {
        try {
            Array[] dimensionData;
            Array[] data;
            NetcdfDataset netcdfDataset = this.ncd;
            synchronized (netcdfDataset) {
                int i;
                data = new Array[this.variables.size()];
                for (i = 0; i < data.length; ++i) {
                    data[i] = this.variables.get(i).read();
                }
                dimensionData = new Array[this.dimensions.size()];
                for (i = 0; i < this.dimensions.size(); ++i) {
                    Variable variable = this.ncd.findVariable(this.dimensions.get(i).getShortName());
                    if (variable == null) continue;
                    dimensionData[i] = variable.read();
                }
            }
            return TupleIterator.wrappedAndMapped((Iterator)new IndexIncrementer(this.dimensions), idx -> {
                Type memberType;
                int i;
                Object[] values = new Object[this.getRawType().size()];
                for (i = 0; i < this.dimensions.size(); ++i) {
                    memberType = ((Struct.StructMember)this.getRawType().getMembers().get(i)).getType();
                    Array variableData = dimensionData[i];
                    values[i] = variableData == null ? java.lang.Integer.valueOf(idx[i]) : memberType.coerce(dimensionData[i].getObject(idx[i]));
                }
                for (i = 0; i < data.length; ++i) {
                    memberType = ((Struct.StructMember)this.getRawType().getMembers().get(i + this.dimensions.size())).getType();
                    Array dataArray = data[i];
                    values[i + this.dimensions.size()] = memberType.coerce(dataArray.getObject(dataArray.getIndex().set(idx)));
                }
                return Tuple.ofValues((Struct)this.getRawType(), (Object[])values);
            });
        }
        catch (IOException e) {
            throw new RiskscapeException((Problems)Problems.caught((Throwable)e));
        }
    }

    protected BaseRelation clone(BaseRelation.Fields fields) {
        return new NetCdfRelation(this.ncd, this.variables, this.dimensions, fields);
    }

    public String getSourceInformation() {
        return this.ncd.toString();
    }

    public static interface LocalProblems
    extends ProblemFactory {
        public Problem mismatch(String var1, List<String> var2, List<String> var3);
    }

    static class IndexIncrementer
    implements Iterator<int[]> {
        private final List<Dimension> dimensions;
        private final int[] indexes;

        IndexIncrementer(List<Dimension> dimensions) {
            this.dimensions = dimensions;
            this.indexes = new int[dimensions.size()];
            this.indexes[0] = -1;
        }

        @Override
        public boolean hasNext() {
            for (int i = 0; i < this.dimensions.size(); ++i) {
                if (this.indexes[i] >= this.dimensions.get(i).getLength() - 1) continue;
                return true;
            }
            return false;
        }

        @Override
        public int[] next() {
            for (int i = 0; i < this.dimensions.size(); ++i) {
                if (this.indexes[i] < this.dimensions.get(i).getLength() - 1) {
                    int n = i;
                    this.indexes[n] = this.indexes[n] + 1;
                    break;
                }
                this.indexes[i] = 0;
            }
            return this.indexes;
        }
    }
}

