/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.netcdf;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import nz.org.riskscape.engine.Engine;
import nz.org.riskscape.engine.data.BookmarkParameters;
import nz.org.riskscape.engine.data.relation.RelationBookmarkParams;
import nz.org.riskscape.engine.data.relation.RelationBookmarkResolver;
import nz.org.riskscape.engine.problem.GeneralProblems;
import nz.org.riskscape.engine.relation.Relation;
import nz.org.riskscape.netcdf.NetCdfRelation;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;
import ucar.nc2.CDMNode;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.NetcdfDatasets;

public class NetCDFResolver
extends RelationBookmarkResolver<Parameters> {
    private final Map<String, String> extensionsToFormats = ImmutableMap.of((Object)"nc", (Object)"netcdf");

    public NetCDFResolver(Engine engine) {
        super(engine);
    }

    protected ResultOrProblems<Relation> createRawRelationFromBookmark(Parameters params) {
        ResultOrProblems bookmarkedPath = this.getBookmarkedPathOr((BookmarkParameters)params);
        if (bookmarkedPath.hasProblems()) {
            return ResultOrProblems.failed((List)bookmarkedPath.getProblems());
        }
        try {
            NetcdfDataset ncd = NetcdfDatasets.openDataset((String)((Path)bookmarkedPath.get()).toString());
            List<String> includeLayers = params.getIncludeLayerList();
            if (includeLayers.isEmpty()) {
                includeLayers = Arrays.asList(((Variable)ncd.getVariables().get(0)).getShortName());
            }
            for (String layer : includeLayers) {
                if (ncd.findVariable(layer) != null) continue;
                List available = ncd.getVariables().stream().map(CDMNode::getShortName).collect(Collectors.toList());
                return ResultOrProblems.failed((Problem[])new Problem[]{GeneralProblems.get().notAnOption(layer, (Object)"layer", available)});
            }
            return NetCdfRelation.of(ncd, includeLayers);
        }
        catch (IOException e) {
            return ResultOrProblems.failed((Problem[])new Problem[]{Problems.caught((Throwable)e)});
        }
    }

    @Generated
    public Map<String, String> getExtensionsToFormats() {
        return this.extensionsToFormats;
    }

    public static class Parameters
    extends RelationBookmarkParams {
        public List<String> getIncludeLayerList() {
            String includedLayers = this.layer.orElse("").trim();
            if ("".equals(includedLayers)) {
                return Collections.emptyList();
            }
            return Arrays.stream(includedLayers.split(",")).map(param -> param.trim()).collect(Collectors.toList());
        }
    }
}

