/*
 * RiskScape™ Copyright New Zealand Institute for Earth Science Limited
 * (Earth Sciences New Zealand) is distributed for research purposes only
 * under the terms of AGPLv3.
 *
 * RiskScape™ Copyright 2025 New Zealand Institute for Earth Science
 * Limited (Earth Sciences New Zealand). All rights reserved. Source code
 * available under the AGPLv3.
 * 
 * This program is free software: you can redistribute it and/or modify it under
 *  the terms of the GNU Affero General Public License as published by the Free
 *  Software Foundation, either version 3 of the License, or (at your option) any
 *  later version.
 * 
 * This program is distributed for RESEARCH PURPOSES ONLY, in the hope that it will
 * be useful for research and education initiatives.
 * 
 * If you are not a researcher, or you are a researcher who wishes to use this
 * program on terms other than AGPLv3 (including those who wish to restrict the
 * distribution of any source code created using this program), please contact:
 * https://riskscape.org.nz
 * 
 * This program is distributed WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Affero General Public License for more details.  You should have received a copy
 * of the GNU Affero General Public License along with this program.  If not, see
 * <http://www.gnu.org/licenses/>.
 * 
 * By way of summary only, under the AGPLv3:
 *     • Permissions of this strongest copyleft license are conditioned
 *       on making available complete source code of licensed works and
 *       modifications, which include larger works using a licensed work,
 *       under the same license.
 *     • Copyright and license notices must be preserved.
 *     • Contributors provide an express grant of patent rights.
 *     • When a modified version is used to provide a service over a
 *       network, the complete source code of the modified version must be made
 *       available.
 */
package nz.org.riskscape.engine.gt;

import org.locationtech.jts.geom.Coordinate;

import nz.org.riskscape.engine.SRIDSet;


/**
 * A helper for creating geometries in a NZMG (EPSG:27200) projection.
 *
 * Of note is that this helper will adjust ordinates to be relative to {@link #NZ_ORIGIN_X} and
 * {@link #NZ_ORIGIN_Y} respectively. This is useful has it allow tests to make geometries with
 * small numbers that would otherwise produce geometries that are not within the EPSG:27200 projected
 * bounds.
 *
 * Please use {@link NZTMGeometryHelper} for new tests going forward. Most GIS
 * providers in NZ recommend using NZTM over NZMG.
 */
@Deprecated
public class NZMGGeometryHelper extends BaseGeometryHelper {

  /**
   * An x axis value for an origin point that is within the nzTransverseMercator projection.
   */
  public static final int NZ_ORIGIN_X = 2700000;

  /**
   * An y axis value for an origin point that is within the nzTransverseMercator projection.
   */
  public static final int NZ_ORIGIN_Y = 6000000;


  public NZMGGeometryHelper(SRIDSet sridSet) {
    super(sridSet, "EPSG:27200");
  }

  /**
   * Creates a {@link Coordinate} where x and y ordinates are offset from {@link #NZ_ORIGIN_X} and
   * {@link #NZ_ORIGIN_Y} respectively.
   *
   * This allows test code to use small values for x/y but the returned {@link Coordinate} will be
   * within the EPSG:2193 projected bounds.
   */
  @Override
  public Coordinate toCoordinate(double x, double y) {
    return super.toCoordinate(NZ_ORIGIN_X + x, NZ_ORIGIN_Y + y);
  }

}
