/*
 * RiskScape™ Copyright New Zealand Institute for Earth Science Limited
 * (Earth Sciences New Zealand) is distributed for research purposes only
 * under the terms of AGPLv3.
 *
 * RiskScape™ Copyright 2025 New Zealand Institute for Earth Science
 * Limited (Earth Sciences New Zealand). All rights reserved. Source code
 * available under the AGPLv3.
 * 
 * This program is free software: you can redistribute it and/or modify it under
 *  the terms of the GNU Affero General Public License as published by the Free
 *  Software Foundation, either version 3 of the License, or (at your option) any
 *  later version.
 * 
 * This program is distributed for RESEARCH PURPOSES ONLY, in the hope that it will
 * be useful for research and education initiatives.
 * 
 * If you are not a researcher, or you are a researcher who wishes to use this
 * program on terms other than AGPLv3 (including those who wish to restrict the
 * distribution of any source code created using this program), please contact:
 * https://riskscape.org.nz
 * 
 * This program is distributed WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Affero General Public License for more details.  You should have received a copy
 * of the GNU Affero General Public License along with this program.  If not, see
 * <http://www.gnu.org/licenses/>.
 * 
 * By way of summary only, under the AGPLv3:
 *     • Permissions of this strongest copyleft license are conditioned
 *       on making available complete source code of licensed works and
 *       modifications, which include larger works using a licensed work,
 *       under the same license.
 *     • Copyright and license notices must be preserved.
 *     • Contributors provide an express grant of patent rights.
 *     • When a modified version is used to provide a service over a
 *       network, the complete source code of the modified version must be made
 *       available.
 */
package nz.org.riskscape.engine.cli;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.LinkedList;
import java.util.Locale;

import lombok.Getter;
import lombok.Setter;
import nz.org.riskscape.cli.AnsiPrintStream;
import nz.org.riskscape.cli.InterruptHandler;
import nz.org.riskscape.cli.Terminal;
import nz.org.riskscape.engine.i18n.Messages;
import nz.org.riskscape.picocli.CommandLine.Help.Ansi;
import nz.org.riskscape.problem.Problem;

public class TestTerminal implements Terminal {

  @Getter
  private final PrintStream err;
  @Getter
  private final PrintStream out;
  @Getter
  private final InputStream in;
  private final BufferedReader reader;
  @Getter @Setter
  private int displayWidth = 80;
  @Getter @Setter
  private int displayHeight = Integer.MAX_VALUE;
  @Getter @Setter
  private boolean tTY = false;
  @Getter
  private final LinkedList<Problem> collectedProblems = new LinkedList<>();
  @Getter
  private final AnsiPrintStream ansiErr;
  @Getter
  private final AnsiPrintStream ansiOut;

  public TestTerminal(PrintStream err, PrintStream out, InputStream in, Messages messages) {
    this(err, out, in, messages, Locale.getDefault());
  }

  public TestTerminal(PrintStream err, PrintStream out, InputStream in, Messages messages, Locale locale) {
    this.err = err;
    this.ansiErr = new AnsiPrintStream(getAnsi(), err);
    this.out = out;
    this.ansiOut = new AnsiPrintStream(this);
    this.in = in;
    this.reader = new BufferedReader(new InputStreamReader(in));
  }

  @Override
  public String readline() throws IOException {
    return reader.readLine();
  }

  @Override
  public void log(Problem problem) {
    collectedProblems.add(problem);
  }

  @Override
  public Locale getLocale() {
    return Locale.getDefault();
  }

  @Override
  public Ansi getAnsi() {
    return Ansi.OFF;
  }

  @Override
  public InterruptHandler setFallbackHandler(InterruptHandler newFallbackHandler) {
    return null;
  }

}
