/*
 * RiskScape™ Copyright New Zealand Institute for Earth Science Limited
 * (Earth Sciences New Zealand) is distributed for research purposes only
 * under the terms of AGPLv3.
 *
 * RiskScape™ Copyright 2025 New Zealand Institute for Earth Science
 * Limited (Earth Sciences New Zealand). All rights reserved. Source code
 * available under the AGPLv3.
 * 
 * This program is free software: you can redistribute it and/or modify it under
 *  the terms of the GNU Affero General Public License as published by the Free
 *  Software Foundation, either version 3 of the License, or (at your option) any
 *  later version.
 * 
 * This program is distributed for RESEARCH PURPOSES ONLY, in the hope that it will
 * be useful for research and education initiatives.
 * 
 * If you are not a researcher, or you are a researcher who wishes to use this
 * program on terms other than AGPLv3 (including those who wish to restrict the
 * distribution of any source code created using this program), please contact:
 * https://riskscape.org.nz
 * 
 * This program is distributed WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Affero General Public License for more details.  You should have received a copy
 * of the GNU Affero General Public License along with this program.  If not, see
 * <http://www.gnu.org/licenses/>.
 * 
 * By way of summary only, under the AGPLv3:
 *     • Permissions of this strongest copyleft license are conditioned
 *       on making available complete source code of licensed works and
 *       modifications, which include larger works using a licensed work,
 *       under the same license.
 *     • Copyright and license notices must be preserved.
 *     • Contributors provide an express grant of patent rights.
 *     • When a modified version is used to provide a service over a
 *       network, the complete source code of the modified version must be made
 *       available.
 */
package nz.org.riskscape.engine.cli;

import java.nio.file.Path;

import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.InitializationError;

import lombok.extern.slf4j.Slf4j;
import nz.org.riskscape.test.TestUtils;

/**
 * Test Runner that will start the test postgis server before running tests.
 *
 * TODO we should probably inject the cnx url in to the tests - that way this could run in docker mode or local mode
 * (or whatever)
 */
@Slf4j
public class PostgisIntegrationTestRunner extends BlockJUnit4ClassRunner {

  public static final int PUBLISHED_PORT = 55432;

  private Path srcRoot;

  public PostgisIntegrationTestRunner(Class<?> klass) throws InitializationError {
    super(klass);
  }

  @Override
  public void run(RunNotifier notifier) {
    this.srcRoot = TestUtils.getRootProjectPath().get();

    startPostgisServer();
    super.run(notifier);
    stopPostgisServer();
  }


  public void startPostgisServer() {
    log.info("Starting postgis docker container...");
    try {
      ProcessBuilder pb = new ProcessBuilder("bin/docker-postgis.sh", "start");
      pb.environment().put("POSTGIS_PUBLISH_PORT", Integer.toString(PUBLISHED_PORT));
      pb.directory(srcRoot.toFile());
      pb.start().waitFor();
      log.info("... Done.");
    } catch (Throwable t) {
      throw new RuntimeException(t);
    }
  }

  public void stopPostgisServer() {
    log.info("Stopping postgis docker container...");
    try {
      ProcessBuilder pb = new ProcessBuilder("bin/docker-postgis.sh", "stop");
      pb.directory(srcRoot.toFile());
      pb.start().waitFor();
      log.info("... Done.");
    } catch (Throwable t) {
      throw new RuntimeException(t);
    }
  }

}
