/*
 * RiskScape™ Copyright New Zealand Institute for Earth Science Limited
 * (Earth Sciences New Zealand) is distributed for research purposes only
 * under the terms of AGPLv3.
 *
 * RiskScape™ Copyright 2025 New Zealand Institute for Earth Science
 * Limited (Earth Sciences New Zealand). All rights reserved. Source code
 * available under the AGPLv3.
 * 
 * This program is free software: you can redistribute it and/or modify it under
 *  the terms of the GNU Affero General Public License as published by the Free
 *  Software Foundation, either version 3 of the License, or (at your option) any
 *  later version.
 * 
 * This program is distributed for RESEARCH PURPOSES ONLY, in the hope that it will
 * be useful for research and education initiatives.
 * 
 * If you are not a researcher, or you are a researcher who wishes to use this
 * program on terms other than AGPLv3 (including those who wish to restrict the
 * distribution of any source code created using this program), please contact:
 * https://riskscape.org.nz
 * 
 * This program is distributed WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Affero General Public License for more details.  You should have received a copy
 * of the GNU Affero General Public License along with this program.  If not, see
 * <http://www.gnu.org/licenses/>.
 * 
 * By way of summary only, under the AGPLv3:
 *     • Permissions of this strongest copyleft license are conditioned
 *       on making available complete source code of licensed works and
 *       modifications, which include larger works using a licensed work,
 *       under the same license.
 *     • Copyright and license notices must be preserved.
 *     • Contributors provide an express grant of patent rights.
 *     • When a modified version is used to provide a service over a
 *       network, the complete source code of the modified version must be made
 *       available.
 */
package nz.org.riskscape.engine.cli.tests;

import static org.hamcrest.Matchers.*;
import static org.junit.Assert.*;

import java.util.Arrays;

import org.junit.Test;

import nz.org.riskscape.engine.test.EngineTestPlugins;

@EngineTestPlugins({ "defaults", "jython" })
public class UnionStepTest extends BaseModelRunCommandTest {

  @Test
  public void canUseUnionStepToCombineBranchesInPipelineModel() throws Exception {
    runCommand.modelId = "union";
    runCommand.run();

    assertThat(openCsv("summary.csv", "consequence", "total"), contains(
        Arrays.asList("Building Exposed", "4054"),
        Arrays.asList("Building Not Exposed", "8466"),
        Arrays.asList("Road Exposed", "172"),
        Arrays.asList("Road Not Exposed", "416")
    ));

    assertThat(openCsv("total_value.csv", "input", "total_value"), contains(
        Arrays.asList("Building Points", "4.73993E8"),
        Arrays.asList("Buildings", "9.94193E8"),
        Arrays.asList("Roads", "1.7926078448E8")
    ));
  }

  @Test
  public void canUseUnionStepToCombineLotsOfPipelineBranches() throws Exception {
    runCommand.modelId = "smoketest";
    runCommand.run();

    assertThat(openCsv("results.csv", "var1", "var2"), containsInAnyOrder(
        Arrays.asList("Cool", ""),
        Arrays.asList("story", ""),
        Arrays.asList("bro", "foo"),
        Arrays.asList("", "bar"),
        Arrays.asList("", "baz")
    ));
  }

  @Test
  public void canUseUnionStepToCombineGeometryIntoSpatialCoverage() throws Exception {
    runCommand.modelId = "combine-geometry";
    runCommand.run();

    assertThat(openCsv("results.csv", "combined"), contains(
        Arrays.asList("true")
    ));
  }
}
