/*
 * RiskScape™ Copyright New Zealand Institute for Earth Science Limited
 * (Earth Sciences New Zealand) is distributed for research purposes only
 * under the terms of AGPLv3.
 *
 * RiskScape™ Copyright 2025 New Zealand Institute for Earth Science
 * Limited (Earth Sciences New Zealand). All rights reserved. Source code
 * available under the AGPLv3.
 * 
 * This program is free software: you can redistribute it and/or modify it under
 *  the terms of the GNU Affero General Public License as published by the Free
 *  Software Foundation, either version 3 of the License, or (at your option) any
 *  later version.
 * 
 * This program is distributed for RESEARCH PURPOSES ONLY, in the hope that it will
 * be useful for research and education initiatives.
 * 
 * If you are not a researcher, or you are a researcher who wishes to use this
 * program on terms other than AGPLv3 (including those who wish to restrict the
 * distribution of any source code created using this program), please contact:
 * https://riskscape.org.nz
 * 
 * This program is distributed WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Affero General Public License for more details.  You should have received a copy
 * of the GNU Affero General Public License along with this program.  If not, see
 * <http://www.gnu.org/licenses/>.
 * 
 * By way of summary only, under the AGPLv3:
 *     • Permissions of this strongest copyleft license are conditioned
 *       on making available complete source code of licensed works and
 *       modifications, which include larger works using a licensed work,
 *       under the same license.
 *     • Copyright and license notices must be preserved.
 *     • Contributors provide an express grant of patent rights.
 *     • When a modified version is used to provide a service over a
 *       network, the complete source code of the modified version must be made
 *       available.
 */
package nz.org.riskscape.engine.cli.tests;

import static org.hamcrest.Matchers.*;
import static org.junit.Assert.*;

import static nz.org.riskscape.engine.Matchers.*;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;

import nz.org.riskscape.engine.output.TestFormat;

/**
 * Integration test to check that model specified save options are passed from the save step down
 * into the writer constructor chain.
 *
 * Uses the {@link TestFormat} to capture used options when the writer is created.
 */
public class SaveFormatOptionsTest extends BaseModelRunCommandTest {

  Optional<?> usedOptions;

  @Before
  public void addFormatToEngine() {
    engine.getFormats().add(new TestFormat((opt) -> usedOptions = opt));
  }

  @After
  public void removeFormatFromEngine() {
    engine.getFormats().remove("test");
  }

  @Test
  public void canSaveWithFormatSpecificOptions() {
    runCommand.modelId = "save-options";
    runCommand.parameters = List.of(
        "format='test'",
        "options={required: 'foobar'}"
    );

    runCommand.run();

    assertThat(usedOptions.get(), allOf(
        hasProperty("required", is("foobar")),
        hasProperty("number", is(10))
    ));
  }

  @Test
  public void canPassEmptyOptionsStruct() throws Exception {
    // check formats with no options can still accept an empty struct.
    // This lets us parameterize the save() options and change them on the fly
    runCommand.modelId = "save-options";
    runCommand.parameters = List.of(
        "format='csv'",
        "options={}"
    );
    runCommand.run();

    assertThat(openCsv("results.csv", "total", "count"), contains(
            Arrays.asList("45", "9")
    ));
  }

}
