/*
 * RiskScape™ Copyright New Zealand Institute for Earth Science Limited
 * (Earth Sciences New Zealand) is distributed for research purposes only
 * under the terms of AGPLv3.
 *
 * RiskScape™ Copyright 2025 New Zealand Institute for Earth Science
 * Limited (Earth Sciences New Zealand). All rights reserved. Source code
 * available under the AGPLv3.
 * 
 * This program is free software: you can redistribute it and/or modify it under
 *  the terms of the GNU Affero General Public License as published by the Free
 *  Software Foundation, either version 3 of the License, or (at your option) any
 *  later version.
 * 
 * This program is distributed for RESEARCH PURPOSES ONLY, in the hope that it will
 * be useful for research and education initiatives.
 * 
 * If you are not a researcher, or you are a researcher who wishes to use this
 * program on terms other than AGPLv3 (including those who wish to restrict the
 * distribution of any source code created using this program), please contact:
 * https://riskscape.org.nz
 * 
 * This program is distributed WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Affero General Public License for more details.  You should have received a copy
 * of the GNU Affero General Public License along with this program.  If not, see
 * <http://www.gnu.org/licenses/>.
 * 
 * By way of summary only, under the AGPLv3:
 *     • Permissions of this strongest copyleft license are conditioned
 *       on making available complete source code of licensed works and
 *       modifications, which include larger works using a licensed work,
 *       under the same license.
 *     • Copyright and license notices must be preserved.
 *     • Contributors provide an express grant of patent rights.
 *     • When a modified version is used to provide a service over a
 *       network, the complete source code of the modified version must be made
 *       available.
 */

package nz.org.riskscape.engine.cli.tests;

import static org.hamcrest.Matchers.*;
import static org.junit.Assert.*;

import java.net.URI;
import java.util.Arrays;
import java.util.List;

import org.junit.Before;
import org.junit.Test;

import nz.org.riskscape.engine.cli.model.RunCommand;
import nz.org.riskscape.engine.test.EngineCommandIntegrationTest;

/**
 * Tests that project that is loaded over the internet works.
 *
 * The project files for this test need to be deployed to the public www releases container. The source
 * files can be found in src/test/homes/RemoteProjectTest
 */
public class RemoteProjectTest extends EngineCommandIntegrationTest {

  protected RunCommand runCommand;

  @Before
  public void populateProject() {
    populateProject(URI.create("https://" + HTTPS_TEST_URI + "/test/RemoteProjectTest/project.ini"));

    runCommand = this.setupCommand(new RunCommand());
    runCommand.runnerOptions.output = getTempDirectory().toString();
    runCommand.modelId = "cars";
  }

  @Test
  public void runsRemoteModel() throws Exception {
    runCommand.run();

    validateCars();
  }

  @Test
  public void runsRemoteModelWithBookmarkFunction() throws Exception {
    runCommand.parameters = Arrays.asList("cars=bookmark('cars.csv')");
    runCommand.run();

    validateCars();
  }

  @Test
  public void runsRemoteModelWithBookmarkWithSpacesInLocation() throws Exception {
    // the oldCars bookmark has a location of `old cars.csv`
    runCommand.parameters = Arrays.asList("cars='oldCars'");
    runCommand.run();

    validateOldCars();
  }

  @Test
  public void runsRemoteModelWithBookmarkFunctionWithSpaces() throws Exception {
    runCommand.parameters = Arrays.asList("cars=bookmark('old cars.csv')");
    runCommand.run();

    validateOldCars();
  }

  void validateCars() throws Exception{
    assertThat(openCars(), contains(
        Arrays.asList("Subaru", "Legacy", "1993"),
        Arrays.asList("VW", "Golf", "2014"),
        Arrays.asList("Kia", "Rio", "2021")
    ));
  }

  void validateOldCars() throws Exception{
    assertThat(openCars(), contains(
        Arrays.asList("Standard", "Flying 9", "1937"),
        Arrays.asList("Chevrolet", "Series AA", "1927")
    ));
  }

  List<List<String>> openCars() throws Exception {
    return openCsv("cars.csv", "make", "model", "year");
  }

}
