/*
 * RiskScape™ Copyright New Zealand Institute for Earth Science Limited
 * (Earth Sciences New Zealand) is distributed for research purposes only
 * under the terms of AGPLv3.
 *
 * RiskScape™ Copyright 2025 New Zealand Institute for Earth Science
 * Limited (Earth Sciences New Zealand). All rights reserved. Source code
 * available under the AGPLv3.
 * 
 * This program is free software: you can redistribute it and/or modify it under
 *  the terms of the GNU Affero General Public License as published by the Free
 *  Software Foundation, either version 3 of the License, or (at your option) any
 *  later version.
 * 
 * This program is distributed for RESEARCH PURPOSES ONLY, in the hope that it will
 * be useful for research and education initiatives.
 * 
 * If you are not a researcher, or you are a researcher who wishes to use this
 * program on terms other than AGPLv3 (including those who wish to restrict the
 * distribution of any source code created using this program), please contact:
 * https://riskscape.org.nz
 * 
 * This program is distributed WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Affero General Public License for more details.  You should have received a copy
 * of the GNU Affero General Public License along with this program.  If not, see
 * <http://www.gnu.org/licenses/>.
 * 
 * By way of summary only, under the AGPLv3:
 *     • Permissions of this strongest copyleft license are conditioned
 *       on making available complete source code of licensed works and
 *       modifications, which include larger works using a licensed work,
 *       under the same license.
 *     • Copyright and license notices must be preserved.
 *     • Contributors provide an express grant of patent rights.
 *     • When a modified version is used to provide a service over a
 *       network, the complete source code of the modified version must be made
 *       available.
 */
package nz.org.riskscape.engine.cli.tests;


import static org.hamcrest.Matchers.containsInAnyOrder;
import static org.junit.Assert.assertThat;

import java.util.Arrays;
import java.util.List;

import org.junit.Test;

/**
 * Test that various coverage formats/projections can be sampled and return expected results.
 */
public class RM482_Coverage_Sampling extends BaseModelRunCommandTest {

  @Test
  public void testCoverageSampling_Arcgrid() throws Exception{
    testCoverageSampling("grid-asc");
  }

  @Test
  public void testCoverageSampling_GeoTif_4326() throws Exception{
    testCoverageSampling("grid-tiff-4326");
  }

  @Test
  public void testCoverageSampling_GeoTif_2193() throws Exception {
    testCoverageSampling("grid-tiff-2193");
  }

  public void testCoverageSampling(String hazard) throws Exception {
    runCommand.modelId = "sample";
    runCommand.parameters = Arrays.asList(String.format("coverage='%s'", hazard));
    runCommand.run();

    List<List<String>> results = openCsv("output.csv", "asset.geom", "asset.expected", "sample");
    assertThat(results, containsInAnyOrder(
        Arrays.asList("POINT (-39 171)", "20", "20.0"),
        Arrays.asList("POINT (-39 173)", "22", "22.0"),
        Arrays.asList("POINT (-39 175)", "24", "24.0"),
        Arrays.asList("POINT (-39 177)", "26", "26.0"),
        Arrays.asList("POINT (-37 171)", "10", "10.0"),
        Arrays.asList("POINT (-37 173)", "12", "12.0"),
        Arrays.asList("POINT (-37 175)", "14", "14.0"),
        Arrays.asList("POINT (-37 177)", "16", "16.0"),
        Arrays.asList("POINT (-35 171)", "0", ""),
        Arrays.asList("POINT (-35 173)", "2", "2.0"),
        Arrays.asList("POINT (-35 175)", "4", "4.0"),
        Arrays.asList("POINT (-35 177)", "6", "6.0")
    ));
  }

}
