/*
 * RiskScape™ Copyright New Zealand Institute for Earth Science Limited
 * (Earth Sciences New Zealand) is distributed for research purposes only
 * under the terms of AGPLv3.
 *
 * RiskScape™ Copyright 2025 New Zealand Institute for Earth Science
 * Limited (Earth Sciences New Zealand). All rights reserved. Source code
 * available under the AGPLv3.
 * 
 * This program is free software: you can redistribute it and/or modify it under
 *  the terms of the GNU Affero General Public License as published by the Free
 *  Software Foundation, either version 3 of the License, or (at your option) any
 *  later version.
 * 
 * This program is distributed for RESEARCH PURPOSES ONLY, in the hope that it will
 * be useful for research and education initiatives.
 * 
 * If you are not a researcher, or you are a researcher who wishes to use this
 * program on terms other than AGPLv3 (including those who wish to restrict the
 * distribution of any source code created using this program), please contact:
 * https://riskscape.org.nz
 * 
 * This program is distributed WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Affero General Public License for more details.  You should have received a copy
 * of the GNU Affero General Public License along with this program.  If not, see
 * <http://www.gnu.org/licenses/>.
 * 
 * By way of summary only, under the AGPLv3:
 *     • Permissions of this strongest copyleft license are conditioned
 *       on making available complete source code of licensed works and
 *       modifications, which include larger works using a licensed work,
 *       under the same license.
 *     • Copyright and license notices must be preserved.
 *     • Contributors provide an express grant of patent rights.
 *     • When a modified version is used to provide a service over a
 *       network, the complete source code of the modified version must be made
 *       available.
 */
package nz.org.riskscape.engine.cli.tests;

import static org.hamcrest.Matchers.*;
import static org.junit.Assert.*;

import org.junit.Test;

import nz.org.riskscape.engine.cli.BaseCliIntegrationTest2;
import nz.org.riskscape.engine.cli.CommandResult;

public class RM419_Project_File extends BaseCliIntegrationTest2 {

  @Test
  public void canLoadTypesFromProjectAndExternalIncludes() throws Exception {
    //This test is showing the without a project file, resources are found based on home directory rules.
    //This it to confirm that these resources aren't included by default when a project file is used.
    CommandResult result1 = runner.execute(defaultCommand("project.ini").subcommands("type", "list"));
    assertThat(result1.exitCode, equalTo(0));
    assertThat(result1.stdout, hasItems(
        containsString("|another-asset"),
        containsString("|asset")
    ));
  }

  @Test
  public void canLoadFunctionFromExternalIncludes() throws Exception {
    //This test is showing the without a project file, resources are found based on home directory rules.
    //This it to confirm that these resources aren't included by default when a project file is used.
    CommandResult result1 = runner.execute(defaultCommand("project.ini").subcommands("function", "list"));
    assertThat(result1.exitCode, equalTo(0));
    assertThat(result1.stdout, hasItems(
        containsString("|asset-echo"),
        containsString("|asset-name")
    ));
  }

  // home directory used to get scanned for all the things, not so any more, it's just for settings and plugins
  @Test
  public void resourcesAreNoLongerLoadedFromHomeDirectoryWhenNoProjectFile() throws Exception {
    //This test is showing the without a project file, resources are found based on home directory rules.
    //This it to confirm that these resources aren't included by default when a project file is used.
    CommandResult result1 = runner.execute(defaultCommand().subcommands("type", "list"));
    assertThat(result1.exitCode, equalTo(0));
    assertThat(result1.stdout, not(hasItems(
        containsString("|asset"))
    ));
    CommandResult result2 = runner.execute(defaultCommand().subcommands("function", "list"));
    assertThat(result2.exitCode, equalTo(0));
    assertThat(result2.stdout, not(hasItems(
        containsString("|asset-echo"),
        containsString("|asset-name"))
    ));
  }

  @Test
  public void onlyResourcesFromProjectFileAreLoaded() throws Exception {
    //This test is showing that without a project file, resources are found based on home directory rules.
    //This it to confirm that these resources aren't included by default when a project file is used.
    CommandResult result1 = runner.execute(defaultCommand("empty-project.ini").subcommands("type", "list"));
    assertThat(result1.exitCode, equalTo(0));
    assertThat(result1.stdout, not(hasItems(
        containsString("|asset")
    )));
    CommandResult result2 = runner.execute(defaultCommand("empty-project.ini").subcommands("function", "list"));
    assertThat(result2.exitCode, equalTo(0));
    assertThat(result2.stdout, not(hasItems(
        containsString("|asset-echo"),
        containsString("|asset-name")
    )));
  }

  @Test
  public void autoImportWillBringInMatchingFiles() throws Exception {
    // there's a types.ini, this matches and so is loaded
    CommandResult result1 = runner.execute(defaultCommand("project-auto-import.ini").subcommands("type", "list"));
    assertThat(result1.exitCode, equalTo(0));
    assertThat(result1.stdout, hasItems(
        containsString("|asset")
    ));
    CommandResult functionResult =
        runner.execute(defaultCommand("project-auto-import.ini").subcommands("function", "list"));

    // auto import won't slurp in functions like the home dir did - it's just for ini files
    assertThat(functionResult.stdout, not(hasItems(
        containsString("|asset-echo"),
        containsString("|asset-name")
    )));

  }
}
