/*
 * RiskScape™ Copyright New Zealand Institute for Earth Science Limited
 * (Earth Sciences New Zealand) is distributed for research purposes only
 * under the terms of AGPLv3.
 *
 * RiskScape™ Copyright 2025 New Zealand Institute for Earth Science
 * Limited (Earth Sciences New Zealand). All rights reserved. Source code
 * available under the AGPLv3.
 * 
 * This program is free software: you can redistribute it and/or modify it under
 *  the terms of the GNU Affero General Public License as published by the Free
 *  Software Foundation, either version 3 of the License, or (at your option) any
 *  later version.
 * 
 * This program is distributed for RESEARCH PURPOSES ONLY, in the hope that it will
 * be useful for research and education initiatives.
 * 
 * If you are not a researcher, or you are a researcher who wishes to use this
 * program on terms other than AGPLv3 (including those who wish to restrict the
 * distribution of any source code created using this program), please contact:
 * https://riskscape.org.nz
 * 
 * This program is distributed WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Affero General Public License for more details.  You should have received a copy
 * of the GNU Affero General Public License along with this program.  If not, see
 * <http://www.gnu.org/licenses/>.
 * 
 * By way of summary only, under the AGPLv3:
 *     • Permissions of this strongest copyleft license are conditioned
 *       on making available complete source code of licensed works and
 *       modifications, which include larger works using a licensed work,
 *       under the same license.
 *     • Copyright and license notices must be preserved.
 *     • Contributors provide an express grant of patent rights.
 *     • When a modified version is used to provide a service over a
 *       network, the complete source code of the modified version must be made
 *       available.
 */
package nz.org.riskscape.engine.cli.tests;

import static org.junit.Assert.*;

import java.nio.file.Paths;

import static org.hamcrest.Matchers.*;

import org.junit.Ignore;
import org.junit.Test;


@Ignore //refer: https://gitlab.catalyst.net.nz/riskscape/riskscape/issues/63
public class RM338_PartiallyUpstreamedFilterAppliesCorrectly extends ModelPipelineIntegrationCliTest {

  @SuppressWarnings("unchecked")
  @Test
  public void theEnumPartIsAppliedByRiskscapeTheBboxByTheShapefileAndFiltersCorrectly() throws Exception {
    riskscapeDir = Paths.get("src", "test", "homes", "rm338-partially-upstreamed-filter-applies-correctly")
        .toAbsolutePath().toString();

    ExecResult result = execute(params.clear()
        .add("--log-level=debug")
        .add("model")
        .add("run")
        .add("default")
        .add("-p=function=nothing")
        .add("-p=asset=mappable")
        .add("-p=include-asset-in-output=true")
        .add("-p=filter=asset.enumval = 'foo' and bbox(asset.the_geom, 0.0, 0.0, 2.0, 2.0)")
        .add("-o=-")
        .add("-f=csv"));

    // this is the relation plucking relevant bits for upstreaming in to the shapefile/featuresource
    assertThat(result.stderr, hasItem(
        containsString("Filter [[ enumval = foo ] AND [ the_geom bbox POLYGON ((0 0, 0 2, 2 2, 2 0, 0 0)) ]] "
            + "converted to "
            + "[ the_geom bbox POLYGON ((0 0, 0 2, 2 2, 2 0, 0 0)) ] "
            + "for push up in to feature source ShapefileDataStore")));

    // check that only the one point came out
    assertThat(result.stdout, contains(
        containsString("the_geom,output,"),
        containsString("foo,house")));
  }

}
