/*
 * RiskScape™ Copyright New Zealand Institute for Earth Science Limited
 * (Earth Sciences New Zealand) is distributed for research purposes only
 * under the terms of AGPLv3.
 *
 * RiskScape™ Copyright 2025 New Zealand Institute for Earth Science
 * Limited (Earth Sciences New Zealand). All rights reserved. Source code
 * available under the AGPLv3.
 * 
 * This program is free software: you can redistribute it and/or modify it under
 *  the terms of the GNU Affero General Public License as published by the Free
 *  Software Foundation, either version 3 of the License, or (at your option) any
 *  later version.
 * 
 * This program is distributed for RESEARCH PURPOSES ONLY, in the hope that it will
 * be useful for research and education initiatives.
 * 
 * If you are not a researcher, or you are a researcher who wishes to use this
 * program on terms other than AGPLv3 (including those who wish to restrict the
 * distribution of any source code created using this program), please contact:
 * https://riskscape.org.nz
 * 
 * This program is distributed WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Affero General Public License for more details.  You should have received a copy
 * of the GNU Affero General Public License along with this program.  If not, see
 * <http://www.gnu.org/licenses/>.
 * 
 * By way of summary only, under the AGPLv3:
 *     • Permissions of this strongest copyleft license are conditioned
 *       on making available complete source code of licensed works and
 *       modifications, which include larger works using a licensed work,
 *       under the same license.
 *     • Copyright and license notices must be preserved.
 *     • Contributors provide an express grant of patent rights.
 *     • When a modified version is used to provide a service over a
 *       network, the complete source code of the modified version must be made
 *       available.
 */

package nz.org.riskscape.engine.cli.tests;

import java.util.List;

import static org.hamcrest.Matchers.*;
import static org.junit.Assert.*;

import java.nio.file.Path;
import java.util.Arrays;

import org.junit.Test;

public class RM159_CSV_Geometry_InputTest extends BaseModelRunCommandTest {

  @Override
  public Path stdhome() {
    return homes().resolve("rm159-csv-geom/");
  }

  @Test
  public void canReadCSVcontainingWKTgeoms() throws Exception {
    doRunAFunctionWithOneHazard("buildings-wkt");
  }

  @Test
  public void canReadCSVcontainingLatLongColumns() throws Exception {
    doRunAFunctionWithOneHazard("buildings-latlong");
  }

  public void doRunAFunctionWithOneHazard(String assetId) throws Exception {
    runCommand.modelId = "loss";
    runCommand.parameters = Arrays.asList(String.format("exposure='%s'", assetId));
    runCommand.run();

    List<List<String>> results = openCsv("results.csv", "exposure.the_geom", "exposure.id", "exposure.value",
        "exposure.type", "hazard_intensity", "consequence");

    assertThat(results, hasSize(11));
    assertThat(results, allOf(
        hasItem(Arrays.asList("POINT (175.1867185105193 -40.782248754477806)", "1", "100", "shed", "","-1")),

        hasItem(Arrays.asList("POINT (175.30758960997954 -40.88248694884024)", "8", "650", "house", "4.0", "2600"))
    ));
  }

}
