/*
 * RiskScape™ Copyright New Zealand Institute for Earth Science Limited
 * (Earth Sciences New Zealand) is distributed for research purposes only
 * under the terms of AGPLv3.
 *
 * RiskScape™ Copyright 2025 New Zealand Institute for Earth Science
 * Limited (Earth Sciences New Zealand). All rights reserved. Source code
 * available under the AGPLv3.
 * 
 * This program is free software: you can redistribute it and/or modify it under
 *  the terms of the GNU Affero General Public License as published by the Free
 *  Software Foundation, either version 3 of the License, or (at your option) any
 *  later version.
 * 
 * This program is distributed for RESEARCH PURPOSES ONLY, in the hope that it will
 * be useful for research and education initiatives.
 * 
 * If you are not a researcher, or you are a researcher who wishes to use this
 * program on terms other than AGPLv3 (including those who wish to restrict the
 * distribution of any source code created using this program), please contact:
 * https://riskscape.org.nz
 * 
 * This program is distributed WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Affero General Public License for more details.  You should have received a copy
 * of the GNU Affero General Public License along with this program.  If not, see
 * <http://www.gnu.org/licenses/>.
 * 
 * By way of summary only, under the AGPLv3:
 *     • Permissions of this strongest copyleft license are conditioned
 *       on making available complete source code of licensed works and
 *       modifications, which include larger works using a licensed work,
 *       under the same license.
 *     • Copyright and license notices must be preserved.
 *     • Contributors provide an express grant of patent rights.
 *     • When a modified version is used to provide a service over a
 *       network, the complete source code of the modified version must be made
 *       available.
 */
package nz.org.riskscape.engine.cli.tests;

import static nz.org.riskscape.engine.cli.tests.TableMatchers.*;
import static org.hamcrest.Matchers.*;
import static org.junit.Assert.*;

import java.nio.file.Path;

import org.junit.Before;
import org.junit.Test;

import nz.org.riskscape.engine.cli.Table;
import nz.org.riskscape.engine.cli.model.ListCommand;
import nz.org.riskscape.engine.test.EngineCommandIntegrationTest;
import nz.org.riskscape.engine.util.Pair;

/**
 * Tests that the new framework-based models can be listed correctly.
 */
@SuppressWarnings("unchecked")
public class ModelListCommandTest extends EngineCommandIntegrationTest {

  Path outputDir;

  @Before
  public void populateProject() {
    populateProject(stdhome());
  }

  @Test
  public void canListModelsFromDifferentFrameworks() throws Exception {
    // evaluate/run the pipeline file produced
    ListCommand cmd = setupCommand(new ListCommand());

    Table models = (Table) cmd.doCommand(project);

    // check we can display valid models of each framework type, along with
    // parameters that are unique to the framework
    assertThat(models, hasRow(
        Pair.of("id", "wizard-good"),
        Pair.of("framework", equalTo("wizard")),
        Pair.of("details", containsString("analysis.function"))));
    assertThat(models, hasRow(
        Pair.of("id", "pipeline-good"),
        Pair.of("framework", equalTo("pipeline")),
        Pair.of("details", equalTo(""))));

    // check that invalid models of each framework type are also listed,
    // along with the error message(s)
    // (Note that the framework isn't listed because the model wasn't successfully built)
    assertThat(models, hasRow(
        Pair.of("id", "wizard-bad"),
        Pair.of("framework", equalTo("")),
        Pair.of("details", containsString("Problems found with 'sample.hazards-by' parameter"))));

    assertThat(models, hasRow(
        Pair.of("id", "pipeline-bad"),
        Pair.of("framework", equalTo("")),
        Pair.of("details", containsString("Got '+', wanted one of ["))));

    // check that models display parameters *and* warnings
    assertThat(models, hasRow(
        Pair.of("id", "pipeline-with-warning"),
        Pair.of("framework", equalTo("pipeline")),
        Pair.of("details", allOf(
            containsString("foo = ['baz']"),
            containsString("Surplus parameters were given that were ignored")
        ))
    ));

    assertThat(models, hasRow(
        Pair.of("id", "no_framework"),
        Pair.of("framework", equalTo("")),
        Pair.of("details", containsString("'framework' parameter is required but was not found"))
    ));
  }

}
