/*
 * RiskScape™ Copyright New Zealand Institute for Earth Science Limited
 * (Earth Sciences New Zealand) is distributed for research purposes only
 * under the terms of AGPLv3.
 *
 * RiskScape™ Copyright 2025 New Zealand Institute for Earth Science
 * Limited (Earth Sciences New Zealand). All rights reserved. Source code
 * available under the AGPLv3.
 * 
 * This program is free software: you can redistribute it and/or modify it under
 *  the terms of the GNU Affero General Public License as published by the Free
 *  Software Foundation, either version 3 of the License, or (at your option) any
 *  later version.
 * 
 * This program is distributed for RESEARCH PURPOSES ONLY, in the hope that it will
 * be useful for research and education initiatives.
 * 
 * If you are not a researcher, or you are a researcher who wishes to use this
 * program on terms other than AGPLv3 (including those who wish to restrict the
 * distribution of any source code created using this program), please contact:
 * https://riskscape.org.nz
 * 
 * This program is distributed WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Affero General Public License for more details.  You should have received a copy
 * of the GNU Affero General Public License along with this program.  If not, see
 * <http://www.gnu.org/licenses/>.
 * 
 * By way of summary only, under the AGPLv3:
 *     • Permissions of this strongest copyleft license are conditioned
 *       on making available complete source code of licensed works and
 *       modifications, which include larger works using a licensed work,
 *       under the same license.
 *     • Copyright and license notices must be preserved.
 *     • Contributors provide an express grant of patent rights.
 *     • When a modified version is used to provide a service over a
 *       network, the complete source code of the modified version must be made
 *       available.
 */

package nz.org.riskscape.engine.cli.tests;

import static org.hamcrest.Matchers.*;
import static org.junit.Assert.*;

import java.util.List;

import org.junit.Test;

import nz.org.riskscape.engine.test.EngineTestPlugins;

@EngineTestPlugins({ "defaults", "beta" })
public class LossesByPeriodTest extends BaseModelRunCommandTest {

  @Test
  public void percentileBasedResultsAreCloseToExpected() throws Exception {
    runCommand.modelId = "oep";
    runCommand.run();

    List<List<String>> results = openCsv("results.csv",
        "RP", "expected","OEP_closest","OEP_percentile","delta_closest","delta_percentile");
    assertThat(results, hasSize(1001));

    // we track the max deltas. this can make it easier to experiment with different
    // options and see the results.
    double maxDeltaClosest = 0D;
    double maxDeltaPercentile = 0D;
    for (List<String> result: results) {
      double deltaClosest = Double.parseDouble(result.get(4));
      double deltaPercentile = Double.parseDouble(result.get(5));

      maxDeltaClosest = Math.max(maxDeltaClosest, deltaClosest);
      maxDeltaPercentile = Math.max(maxDeltaPercentile, deltaPercentile);

      // percentage results are always very very close to expected
      assertThat(deltaPercentile, lessThan(0.0001D));

      // sometimes closest ranked gets an exact match. But percentage is always very close.
      assertThat(deltaPercentile, lessThanOrEqualTo(deltaClosest + 0.1));
    }
    System.out.format("maxDeltaClosest: %f%n", maxDeltaClosest);
    System.out.format("maxDeltaPercentile: %f%n", maxDeltaPercentile);
  }

}
