/*
 * RiskScape™ Copyright New Zealand Institute for Earth Science Limited
 * (Earth Sciences New Zealand) is distributed for research purposes only
 * under the terms of AGPLv3.
 *
 * RiskScape™ Copyright 2025 New Zealand Institute for Earth Science
 * Limited (Earth Sciences New Zealand). All rights reserved. Source code
 * available under the AGPLv3.
 * 
 * This program is free software: you can redistribute it and/or modify it under
 *  the terms of the GNU Affero General Public License as published by the Free
 *  Software Foundation, either version 3 of the License, or (at your option) any
 *  later version.
 * 
 * This program is distributed for RESEARCH PURPOSES ONLY, in the hope that it will
 * be useful for research and education initiatives.
 * 
 * If you are not a researcher, or you are a researcher who wishes to use this
 * program on terms other than AGPLv3 (including those who wish to restrict the
 * distribution of any source code created using this program), please contact:
 * https://riskscape.org.nz
 * 
 * This program is distributed WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Affero General Public License for more details.  You should have received a copy
 * of the GNU Affero General Public License along with this program.  If not, see
 * <http://www.gnu.org/licenses/>.
 * 
 * By way of summary only, under the AGPLv3:
 *     • Permissions of this strongest copyleft license are conditioned
 *       on making available complete source code of licensed works and
 *       modifications, which include larger works using a licensed work,
 *       under the same license.
 *     • Copyright and license notices must be preserved.
 *     • Contributors provide an express grant of patent rights.
 *     • When a modified version is used to provide a service over a
 *       network, the complete source code of the modified version must be made
 *       available.
 */

package nz.org.riskscape.engine.cli.tests;


import static org.hamcrest.Matchers.*;
import static org.junit.Assert.*;

import java.util.List;

import org.junit.Test;


public class GL288_Aggregate_StructsTest extends BaseModelRunCommandTest {

  @Test
  public void canAggregateHazardAndCallClassifierFunction() throws Exception {
    runCommand.modelId = "fire_agg_hazard_classifier";
    runCommand.runnerOptions.format = "csv";
    runCommand.doCommand(project);

    List<List<String>> rows = readCsvColumns("event_impact_table.csv", "exposure.use",
        "consequence.strength", "consequence.loss");

    assertThat(
      rows,
      containsInAnyOrder(
          // not going to assert the mean calculations, we do that in a lot of other places as well
          contains("pasture", "12.0", "120000.0"),
          contains("forest", "14.0", "70000.0"),
          contains("scrub", "", ""),
          contains("fire-free", "", "")
      )
    );
  }

  @Test
  public void canAggregateHazardAndCallPythonFunction() throws Exception {
    runCommand.modelId = "fire_agg_hazard_py";
    runCommand.runnerOptions.format = "csv";
    runCommand.doCommand(project);

    List<List<String>> rows = readCsvColumns("event_impact_table.csv", "exposure.use",
        "consequence.strength", "consequence.loss");

    assertThat(
      rows,
      containsInAnyOrder(
          // not going to assert the mean calculations, we do that in a lot of other places as well
          contains("pasture", "12.0", "120000.0"),
          contains("forest", "14.0", "70000.0"),
          contains("scrub", "", ""),
          contains("fire-free", "", "")
      )
    );
  }

  @Test
  public void canAggregateConsequenceFromClassifierFunction() throws Exception {
    runCommand.modelId = "fire_agg_consequence_classifier";
    runCommand.runnerOptions.format = "csv";
    runCommand.doCommand(project);

    List<List<String>> rows = readCsvColumns("event_impact_table.csv",
        "exposure.use", "consequence.strength", "consequence.loss");

    assertThat(
      rows,
      containsInAnyOrder(
          // not going to assert the mean calculations, we do that in a lot of other places as well
          contains("pasture", "12.0", "120000.0"),
          contains("forest", "14.0", "70000.0"),
          contains("scrub", "", ""),
          contains("fire-free", "", "")
      )
    );
  }

  @Test
  public void canAggregateConsequenceFromPythonFunction() throws Exception {
    runCommand.modelId = "fire_agg_consequence_py";
    runCommand.runnerOptions.format = "csv";
    runCommand.doCommand(project);

    List<List<String>> rows = readCsvColumns("event_impact_table.csv",
        "exposure.use", "consequence.strength", "consequence.loss");

    assertThat(
      rows,
      containsInAnyOrder(
          // not going to assert the mean calculations, we do that in a lot of other places as well
          contains("pasture", "12.0", "120000.0"),
          contains("forest", "14.0", "70000.0"),
          contains("scrub", "", ""),
          contains("fire-free", "", "")
      )
    );
  }

}
