/*
 * RiskScape™ Copyright New Zealand Institute for Earth Science Limited
 * (Earth Sciences New Zealand) is distributed for research purposes only
 * under the terms of AGPLv3.
 *
 * RiskScape™ Copyright 2025 New Zealand Institute for Earth Science
 * Limited (Earth Sciences New Zealand). All rights reserved. Source code
 * available under the AGPLv3.
 * 
 * This program is free software: you can redistribute it and/or modify it under
 *  the terms of the GNU Affero General Public License as published by the Free
 *  Software Foundation, either version 3 of the License, or (at your option) any
 *  later version.
 * 
 * This program is distributed for RESEARCH PURPOSES ONLY, in the hope that it will
 * be useful for research and education initiatives.
 * 
 * If you are not a researcher, or you are a researcher who wishes to use this
 * program on terms other than AGPLv3 (including those who wish to restrict the
 * distribution of any source code created using this program), please contact:
 * https://riskscape.org.nz
 * 
 * This program is distributed WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Affero General Public License for more details.  You should have received a copy
 * of the GNU Affero General Public License along with this program.  If not, see
 * <http://www.gnu.org/licenses/>.
 * 
 * By way of summary only, under the AGPLv3:
 *     • Permissions of this strongest copyleft license are conditioned
 *       on making available complete source code of licensed works and
 *       modifications, which include larger works using a licensed work,
 *       under the same license.
 *     • Copyright and license notices must be preserved.
 *     • Contributors provide an express grant of patent rights.
 *     • When a modified version is used to provide a service over a
 *       network, the complete source code of the modified version must be made
 *       available.
 */
package nz.org.riskscape.engine.cli.tests;

import static org.hamcrest.Matchers.*;
import static org.junit.Assert.*;

import java.util.Arrays;
import java.util.List;

import org.junit.Test;

public class DynamicRasterLayerBookmarksTest extends BaseModelRunCommandTest {

  @Test
  public void canSampleAListOfRasterLayersUsingBookmarkTemplate() throws Exception {
    runCommand.modelId = "sample_dynamic_coverage";
    runCommand.parameters = Arrays.asList("param.to_coverage = bookmark('template', { location: filepath })");
    runCommand.doCommand(project);

    List<List<String>> rows = readCsvColumns("results.csv", "grid_size", "depth");
    assertThat(rows, contains(
            contains("10", "1.52"),
            contains("50", "2.3")
        )
    );
  }

  @Test
  public void canSampleAListOfRasterLayersUsingType() throws Exception {
    // same as previous, but we use bookmark(type:) without a bookmark template
    runCommand.modelId = "sample_dynamic_coverage";
    runCommand.parameters = Arrays.asList("param.to_coverage = bookmark(filepath, {}, type: 'coverage(floating)')");
    runCommand.doCommand(project);

    List<List<String>> rows = readCsvColumns("results.csv", "grid_size", "depth");
    assertThat(rows, contains(
            contains("10", "1.52"),
            contains("50", "2.3")
        )
    );
  }

  @Test
  public void canComputeBoundsFromEachLayer() throws Exception {
    runCommand.modelId = "report-bounds";
    runCommand.doCommand(project);

    List<List<String>> rows = readCsvColumns("results.csv", "source", "min_x", "max_x", "min_y", "max_y");

    // model should report the same bounds as riskscape bookmark info
    assertThat(rows, contains(
            // EPSG:4326 [-74.0458 : -73.9721 East, 40.6849 : 40.7813 North]
            contains("Kaiju", "-74.0458", "-73.9721", "40.6849", "40.7813"),
            // EPSG:4326 [-171.7411 : -171.3882 East, -14.0835 : -13.9829 North]
            contains("Samoa", "-171.7411", "-171.3882", "-14.0835", "-13.9829")
        )
    );
  }

}
