/*
 * RiskScape™ Copyright New Zealand Institute for Earth Science Limited
 * (Earth Sciences New Zealand) is distributed for research purposes only
 * under the terms of AGPLv3.
 *
 * RiskScape™ Copyright 2025 New Zealand Institute for Earth Science
 * Limited (Earth Sciences New Zealand). All rights reserved. Source code
 * available under the AGPLv3.
 * 
 * This program is free software: you can redistribute it and/or modify it under
 *  the terms of the GNU Affero General Public License as published by the Free
 *  Software Foundation, either version 3 of the License, or (at your option) any
 *  later version.
 * 
 * This program is distributed for RESEARCH PURPOSES ONLY, in the hope that it will
 * be useful for research and education initiatives.
 * 
 * If you are not a researcher, or you are a researcher who wishes to use this
 * program on terms other than AGPLv3 (including those who wish to restrict the
 * distribution of any source code created using this program), please contact:
 * https://riskscape.org.nz
 * 
 * This program is distributed WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Affero General Public License for more details.  You should have received a copy
 * of the GNU Affero General Public License along with this program.  If not, see
 * <http://www.gnu.org/licenses/>.
 * 
 * By way of summary only, under the AGPLv3:
 *     • Permissions of this strongest copyleft license are conditioned
 *       on making available complete source code of licensed works and
 *       modifications, which include larger works using a licensed work,
 *       under the same license.
 *     • Copyright and license notices must be preserved.
 *     • Contributors provide an express grant of patent rights.
 *     • When a modified version is used to provide a service over a
 *       network, the complete source code of the modified version must be made
 *       available.
 */

package nz.org.riskscape.engine.cli.tests;

import static org.hamcrest.Matchers.*;
import static org.junit.Assert.*;

import java.util.List;

import org.junit.Test;

import nz.org.riskscape.engine.test.EngineTestPlugins;

@EngineTestPlugins({ "defaults", "beta" })
public class CoverageToRelationTest extends BaseModelRunCommandTest {

  @Test
  public void canRunModelWithConstantCoverage() throws Exception {
    runCommand.modelId = "constant-to-relation";
    runCommand.doCommand(project);

    List<List<String>> results = openCsv("boxes.csv","relation.value","relation.geom", "testPoint", "hasTestPoint");

    assertThat(results, hasSize(16));
    // spot check some results
    assertThat(results, hasItem(List.of(
        "1.0",
        "POLYGON ((1800050 5500000, 1800100 5500000, 1800100 5500050, 1800050 5500050, 1800050 5500000))",
        // the ordinate order on testPoint looks a little wacky, but that's because 2193 is yx
        // but coverages are always xy
        "POINT (5500050 1800050)",
        "true"
    )));
    assertThat(results, hasItem(List.of(
        "3.0",
        "POLYGON ((1800000 5500150, 1800050 5500150, 1800050 5500200, 1800000 5500200, 1800000 5500150))",
        "POINT (5500050 1800050)",
        "false"
    )));
  }

  @Test
  public void canRunModelWithDynamicCoverage() throws Exception {
    runCommand.modelId = "dynamic-to-relation";
    runCommand.doCommand(project);

    List<List<String>> results = openCsv("boxes.csv","relation.value","relation.geom", "testPoint", "hasTestPoint");

    assertThat(results, hasSize(31));
    // spot check some results
    assertThat(results, hasItem(List.of(
        "1.0",
        "POLYGON ((1800050 5500000, 1800100 5500000, 1800100 5500050, 1800050 5500050, 1800050 5500000))",
        "POINT (5500050 1800050)",
        "true"
    )));
    assertThat(results, hasItem(List.of(
        "3.0",
        "POLYGON ((1800000 5500150, 1800050 5500150, 1800050 5500200, 1800000 5500200, 1800000 5500150))",
        "POINT (5500050 1800050)",
        "false"
    )));

    assertThat(results, hasItem(List.of(
        "1.0",
        "POLYGON ((175.3651462818848 -40.62637814276601, 175.36567530472593 -40.62637814276601, "
            + "175.36567530472593 -40.625849119924844, 175.3651462818848 -40.625849119924844, "
            + "175.3651462818848 -40.62637814276601))",
        "POINT (5500050 1800050)",
        // finding the intersection with testPoint shows that the geometries have not lost their CRS
        "true"
    )));
  }

}
