/*
 * RiskScape™ Copyright New Zealand Institute for Earth Science Limited
 * (Earth Sciences New Zealand) is distributed for research purposes only
 * under the terms of AGPLv3.
 *
 * RiskScape™ Copyright 2025 New Zealand Institute for Earth Science
 * Limited (Earth Sciences New Zealand). All rights reserved. Source code
 * available under the AGPLv3.
 * 
 * This program is free software: you can redistribute it and/or modify it under
 *  the terms of the GNU Affero General Public License as published by the Free
 *  Software Foundation, either version 3 of the License, or (at your option) any
 *  later version.
 * 
 * This program is distributed for RESEARCH PURPOSES ONLY, in the hope that it will
 * be useful for research and education initiatives.
 * 
 * If you are not a researcher, or you are a researcher who wishes to use this
 * program on terms other than AGPLv3 (including those who wish to restrict the
 * distribution of any source code created using this program), please contact:
 * https://riskscape.org.nz
 * 
 * This program is distributed WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Affero General Public License for more details.  You should have received a copy
 * of the GNU Affero General Public License along with this program.  If not, see
 * <http://www.gnu.org/licenses/>.
 * 
 * By way of summary only, under the AGPLv3:
 *     • Permissions of this strongest copyleft license are conditioned
 *       on making available complete source code of licensed works and
 *       modifications, which include larger works using a licensed work,
 *       under the same license.
 *     • Copyright and license notices must be preserved.
 *     • Contributors provide an express grant of patent rights.
 *     • When a modified version is used to provide a service over a
 *       network, the complete source code of the modified version must be made
 *       available.
 */
package nz.org.riskscape.engine.cli.tests;

import static org.junit.Assert.*;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.junit.Test;

public class ContinuousFunctionsTests extends BaseModelRunCommandTest {

  @Test
  public void canBuildAndExecuteUsingContinuousInterpolationFunctions() throws Exception {
    runCommand.runnerOptions.output = getTempDirectory().toString();
    runCommand.runnerOptions.replace = true;

    List<String> models = Arrays.asList(
        "no-interpolation",
        "simple-interpolation",
        "stacked-interpolation"
    );

    for (String modelId : models) {
      reset();
      runCommand.modelId = modelId;
      runCommand.run();
    }

    // I haven't done the maths to check these are correct, they are just the rounded numbers from the no-interpolation
    // model that I've pasted in here when writing the test - I'm mostly concerned that the interpolated results match
    // what's in the non-interpolated losses.
    Map<String, Double> expectedLosses = new HashMap<>();
    expectedLosses.put("1", 1025D);
    expectedLosses.put("2", 1377D);
    expectedLosses.put("3", 707D);

    for (String modelId : models) {
      Iterator<String> eventIds = Arrays.asList("1", "2", "3").iterator();

      Iterator<List<String>> losses = openCsv("event-loss-" + modelId + ".csv", "event_id", "total_loss").iterator();
      while (losses.hasNext()) {
        String expectedEventId = eventIds.next();

        List<String> row = losses.next();
        String actualEventId = row.get(0);
        String checking = "loss for event id " + actualEventId + " and model " + modelId;

        double actualLoss;
        try {
          actualLoss = Double.valueOf(row.get(1));
        } catch (NumberFormatException ex) {
          fail(checking + " loss not a floating point number");
          return;
        }

        assertEquals(checking, expectedEventId, actualEventId);
        assertEquals(checking, expectedLosses.get(actualEventId), actualLoss, 2.5);
      }
    }
  }

}
