from nz.org.riskscape.engine.types import Nullable, Struct, Types

ID = 'one-hazard'
DESCRIPTION = "applies a single hazard to asset"

ASSET_TYPE = Struct.of('id', Types.INTEGER) \
  .and('value', Types.INTEGER) \
  .and('type', Types.TEXT).build()

HAZARD_TYPE = Nullable.of(Struct.of('value', Types.FLOATING))

ARGUMENT_TYPES = [ASSET_TYPE, HAZARD_TYPE]
RETURN_TYPE = Nullable.INTEGER

def function(asset, hazard):
  if hazard is None:
    return -1
  return asset.get('value') * hazard.get('value')
