from nz.org.riskscape.engine.types import Types, Struct

ID = 'identify'
DESCRIPTION = "output identifies the asset/hazard"

ARGUMENT_TYPES = ['feature', Types.FLOATING]
RETURN_TYPE = Struct.of('asset-desc', Types.TEXT) \
  .and('hazard-value', Types.INTEGER) \
  .build()

def function(asset, hazard):
  loss = {}
  loss['asset-desc'] = asset['desc']
  loss['hazard-value'] = hazard
  return loss
