/*
 * RiskScape™ Copyright New Zealand Institute for Earth Science Limited
 * (Earth Sciences New Zealand) is distributed for research purposes only
 * under the terms of AGPLv3.
 *
 * RiskScape™ Copyright 2025 New Zealand Institute for Earth Science
 * Limited (Earth Sciences New Zealand). All rights reserved. Source code
 * available under the AGPLv3.
 * 
 * This program is free software: you can redistribute it and/or modify it under
 *  the terms of the GNU Affero General Public License as published by the Free
 *  Software Foundation, either version 3 of the License, or (at your option) any
 *  later version.
 * 
 * This program is distributed for RESEARCH PURPOSES ONLY, in the hope that it will
 * be useful for research and education initiatives.
 * 
 * If you are not a researcher, or you are a researcher who wishes to use this
 * program on terms other than AGPLv3 (including those who wish to restrict the
 * distribution of any source code created using this program), please contact:
 * https://riskscape.org.nz
 * 
 * This program is distributed WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Affero General Public License for more details.  You should have received a copy
 * of the GNU Affero General Public License along with this program.  If not, see
 * <http://www.gnu.org/licenses/>.
 * 
 * By way of summary only, under the AGPLv3:
 *     • Permissions of this strongest copyleft license are conditioned
 *       on making available complete source code of licensed works and
 *       modifications, which include larger works using a licensed work,
 *       under the same license.
 *     • Copyright and license notices must be preserved.
 *     • Contributors provide an express grant of patent rights.
 *     • When a modified version is used to provide a service over a
 *       network, the complete source code of the modified version must be made
 *       available.
 */
package nz.org.riskscape.wizard.bld;

import java.util.Arrays;
import java.util.List;

import lombok.Getter;
import nz.org.riskscape.engine.RiskscapeException;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.wizard.Answer;
import nz.org.riskscape.wizard.WizardProblems;
import nz.org.riskscape.wizard.bld.change.BadPipelineChangeException;
import nz.org.riskscape.wizard.bld.dsl.PipelineChangeInput;

/**
 * Thrown when we cannot generate a {@link PipelineChange} because the user has supplied an invalid response.  This is
 * always a user error, as opposed to {@link BadPipelineChangeException}, which is a survey coding error
 *
 * This class can be useful when:
 * - the user has given us a hand-grenade that will explode further down the line, for somewhat unrelated questions.
 * - we can provide a much simpler, clearer error message than realizing a bad expression/step would.
 */
public class InvalidAnswerException extends RiskscapeException {

  @Getter
  private IncrementalBuildState buildState;
  @Getter
  private Answer answer;

  public InvalidAnswerException(PipelineChangeInput input, List<Problem> childProblems) {
    super(WizardProblems.get().invalidAnswer(input.getAnswer().toParameter()).withChildren(childProblems));
    this.buildState = input.getBuildState();
    this.answer = input.getAnswer();
  }

  public InvalidAnswerException(PipelineChangeInput input, Problem... problems) {
    this(input, Arrays.asList(problems));
  }
}
