/*
 * RiskScape™ Copyright New Zealand Institute for Earth Science Limited
 * (Earth Sciences New Zealand) is distributed for research purposes only
 * under the terms of AGPLv3.
 *
 * RiskScape™ Copyright 2025 New Zealand Institute for Earth Science
 * Limited (Earth Sciences New Zealand). All rights reserved. Source code
 * available under the AGPLv3.
 * 
 * This program is free software: you can redistribute it and/or modify it under
 *  the terms of the GNU Affero General Public License as published by the Free
 *  Software Foundation, either version 3 of the License, or (at your option) any
 *  later version.
 * 
 * This program is distributed for RESEARCH PURPOSES ONLY, in the hope that it will
 * be useful for research and education initiatives.
 * 
 * If you are not a researcher, or you are a researcher who wishes to use this
 * program on terms other than AGPLv3 (including those who wish to restrict the
 * distribution of any source code created using this program), please contact:
 * https://riskscape.org.nz
 * 
 * This program is distributed WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Affero General Public License for more details.  You should have received a copy
 * of the GNU Affero General Public License along with this program.  If not, see
 * <http://www.gnu.org/licenses/>.
 * 
 * By way of summary only, under the AGPLv3:
 *     • Permissions of this strongest copyleft license are conditioned
 *       on making available complete source code of licensed works and
 *       modifications, which include larger works using a licensed work,
 *       under the same license.
 *     • Copyright and license notices must be preserved.
 *     • Contributors provide an express grant of patent rights.
 *     • When a modified version is used to provide a service over a
 *       network, the complete source code of the modified version must be made
 *       available.
 */
package nz.org.riskscape.wizard.bind;

import static nz.org.riskscape.wizard.AskerHints.*;

import nz.org.riskscape.engine.rl.FunctionCallPrototype;
import nz.org.riskscape.rl.TokenTypes;
import nz.org.riskscape.rl.ast.PropertyAccess;
import nz.org.riskscape.wizard.AskAs;
import nz.org.riskscape.wizard.Composite;
import nz.org.riskscape.wizard.CompositeField;

@Composite
public class AggregationExpression {

  public static final AskAs<AggregationExpression> ASK_AS =
      new AskAs<>(AggregationExpression.class, AggregationExpression::toSource);

  @CompositeField(tagKey = PICK_ATTRIBUTE, tagValue = NUMERIC)
  public PropertyAccess attribute;

  @CompositeField(tagKey = AGGREGATION)
  public FunctionCallPrototype function;

  @CompositeField
  public String resultName;

  /**
   * @return the aggregation expression in String form.  NB we omit the braces here because
   * * 1) it's easier to read when written in config, e.g. foo.bar = min(loss) as min_losses is simpler than {min(loss)
   * vs min_losses} and
   * * 2) as long as the question was for StructDeclaration, it'll bind just fine thanks to some special case logic for
   * binding StructDeclaration expressions.
   */
  public String toSource() {
    return String.format("%s as %s",
        function.setFirstArgument(attribute.toSource()).build().toSource(),
        TokenTypes.quoteIdent(resultName));
  }
}
