/*
 * RiskScape™ Copyright New Zealand Institute for Earth Science Limited
 * (Earth Sciences New Zealand) is distributed for research purposes only
 * under the terms of AGPLv3.
 *
 * RiskScape™ Copyright 2025 New Zealand Institute for Earth Science
 * Limited (Earth Sciences New Zealand). All rights reserved. Source code
 * available under the AGPLv3.
 * 
 * This program is free software: you can redistribute it and/or modify it under
 *  the terms of the GNU Affero General Public License as published by the Free
 *  Software Foundation, either version 3 of the License, or (at your option) any
 *  later version.
 * 
 * This program is distributed for RESEARCH PURPOSES ONLY, in the hope that it will
 * be useful for research and education initiatives.
 * 
 * If you are not a researcher, or you are a researcher who wishes to use this
 * program on terms other than AGPLv3 (including those who wish to restrict the
 * distribution of any source code created using this program), please contact:
 * https://riskscape.org.nz
 * 
 * This program is distributed WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Affero General Public License for more details.  You should have received a copy
 * of the GNU Affero General Public License along with this program.  If not, see
 * <http://www.gnu.org/licenses/>.
 * 
 * By way of summary only, under the AGPLv3:
 *     • Permissions of this strongest copyleft license are conditioned
 *       on making available complete source code of licensed works and
 *       modifications, which include larger works using a licensed work,
 *       under the same license.
 *     • Copyright and license notices must be preserved.
 *     • Contributors provide an express grant of patent rights.
 *     • When a modified version is used to provide a service over a
 *       network, the complete source code of the modified version must be made
 *       available.
 */
package nz.org.riskscape.wizard.ask;

import java.util.List;

import nz.org.riskscape.engine.i18n.TranslationContext;
import nz.org.riskscape.problem.ResultOrProblems;
import nz.org.riskscape.wizard.Answer;
import nz.org.riskscape.wizard.Answer.Response;
import nz.org.riskscape.wizard.Choice;
import nz.org.riskscape.wizard.CliPrompter;
import nz.org.riskscape.wizard.Question;
import nz.org.riskscape.wizard.bld.IncrementalBuildState;

public class DefaultAsker extends CompatAsker {

  public DefaultAsker(TranslationContext messageSource) {
    super(messageSource);
  }

  @Override
  public boolean canAsk(IncrementalBuildState buildState, Question question) {
    return true;
  }

  @Override
  public ResultOrProblems<Response> ask(CliPrompter cliPrompter, IncrementalBuildState buildState, Question question) {
    // if the question has choices, just let the user pick from those
    List<Choice> choices = question.getChoices(buildState);
    if (!choices.isEmpty()) {
      Choice chosen = pickChoice(choices, cliPrompter, cliPrompter.getPrompt(question));
      return ResultOrProblems.of(new Response(chosen.getLabel(translationContext), chosen.getValue()));
    }

    // otherwise the user needs to type out an answer by hand
    String input = cliPrompter.readlineWithTitle(cliPrompter.getPrompt(question));
    return Answer.bind(buildState.getBindingContext(), question, input);
  }


}
