/*
 * RiskScape™ Copyright New Zealand Institute for Earth Science Limited
 * (Earth Sciences New Zealand) is distributed for research purposes only
 * under the terms of AGPLv3.
 *
 * RiskScape™ Copyright 2025 New Zealand Institute for Earth Science
 * Limited (Earth Sciences New Zealand). All rights reserved. Source code
 * available under the AGPLv3.
 * 
 * This program is free software: you can redistribute it and/or modify it under
 *  the terms of the GNU Affero General Public License as published by the Free
 *  Software Foundation, either version 3 of the License, or (at your option) any
 *  later version.
 * 
 * This program is distributed for RESEARCH PURPOSES ONLY, in the hope that it will
 * be useful for research and education initiatives.
 * 
 * If you are not a researcher, or you are a researcher who wishes to use this
 * program on terms other than AGPLv3 (including those who wish to restrict the
 * distribution of any source code created using this program), please contact:
 * https://riskscape.org.nz
 * 
 * This program is distributed WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Affero General Public License for more details.  You should have received a copy
 * of the GNU Affero General Public License along with this program.  If not, see
 * <http://www.gnu.org/licenses/>.
 * 
 * By way of summary only, under the AGPLv3:
 *     • Permissions of this strongest copyleft license are conditioned
 *       on making available complete source code of licensed works and
 *       modifications, which include larger works using a licensed work,
 *       under the same license.
 *     • Copyright and license notices must be preserved.
 *     • Contributors provide an express grant of patent rights.
 *     • When a modified version is used to provide a service over a
 *       network, the complete source code of the modified version must be made
 *       available.
 */
package nz.org.riskscape.oq;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Map;

import org.junit.BeforeClass;
import org.junit.experimental.categories.Category;

import com.google.common.collect.Maps;

import nz.org.riskscape.engine.ProjectTest;
import nz.org.riskscape.engine.data.Bookmark;
import nz.org.riskscape.engine.data.ResolvedBookmark;

import hdf.hdf5lib.H5;

import nz.org.riskscape.hdf5.H5File;
import nz.org.riskscape.hdf5.H5TestMarker;

@Category(H5TestMarker.class)
public class BaseHdf5Test extends ProjectTest {


  private final Path examplesDir = Paths.get("src", "test", "resources");
  private final OpenQuakeResolver openquakeResolver = new OpenQuakeResolver(engine);

  @BeforeClass
  public static void setupH5Library() {
    if (System.getProperty(H5.H5PATH_PROPERTY_KEY) == null) {
      System.setProperty(H5.H5PATH_PROPERTY_KEY, "/opt/hdf5-1.12.2/lib/libhdf5_java.so");
    }
  }

  public static H5File scenarioFile() {
    return new H5File(Paths.get("src", "test", "resources", "openquake-scenario-10-events.hdf5"));
  }

  public static H5File probabilisticFile() {
    return new H5File(Paths.get("src", "test", "resources", "openquake-probabilistic-small.hdf5"));
  }

  protected Bookmark bookmark(String fileName, Map<String, String> unparsed) {
    return new Bookmark("id", "desc", "openquake", examplesDir.resolve(fileName).toUri(),
        Maps.transformValues(unparsed, Collections::singletonList));
  }

  protected ResolvedBookmark resolve(Bookmark bookmark) {
    return openquakeResolver.resolve(bookmark, bindingContext).get();
  }

}
