/*
 * RiskScape™ Copyright New Zealand Institute for Earth Science Limited
 * (Earth Sciences New Zealand) is distributed for research purposes only
 * under the terms of AGPLv3.
 *
 * RiskScape™ Copyright 2025 New Zealand Institute for Earth Science
 * Limited (Earth Sciences New Zealand). All rights reserved. Source code
 * available under the AGPLv3.
 * 
 * This program is free software: you can redistribute it and/or modify it under
 *  the terms of the GNU Affero General Public License as published by the Free
 *  Software Foundation, either version 3 of the License, or (at your option) any
 *  later version.
 * 
 * This program is distributed for RESEARCH PURPOSES ONLY, in the hope that it will
 * be useful for research and education initiatives.
 * 
 * If you are not a researcher, or you are a researcher who wishes to use this
 * program on terms other than AGPLv3 (including those who wish to restrict the
 * distribution of any source code created using this program), please contact:
 * https://riskscape.org.nz
 * 
 * This program is distributed WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Affero General Public License for more details.  You should have received a copy
 * of the GNU Affero General Public License along with this program.  If not, see
 * <http://www.gnu.org/licenses/>.
 * 
 * By way of summary only, under the AGPLv3:
 *     • Permissions of this strongest copyleft license are conditioned
 *       on making available complete source code of licensed works and
 *       modifications, which include larger works using a licensed work,
 *       under the same license.
 *     • Copyright and license notices must be preserved.
 *     • Contributors provide an express grant of patent rights.
 *     • When a modified version is used to provide a service over a
 *       network, the complete source code of the modified version must be made
 *       available.
 */
package nz.org.riskscape.ogr;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import nz.org.riskscape.engine.Engine;
import nz.org.riskscape.engine.RiskscapeException;
import nz.org.riskscape.engine.plugin.PluginDescriptor;
import nz.org.riskscape.engine.plugin.PluginRuntimeException;
import nz.org.riskscape.problem.Problem;

public class Plugin extends nz.org.riskscape.engine.plugin.Plugin {

  private OgrHelper ogrHelper;

  public Plugin(PluginDescriptor pDescriptor) {
    super(pDescriptor);
  }

  @Override
  public List<Problem> initializeEngine(Engine engine) {
    List<Problem> problems = new ArrayList<>();

    if (ogrHelper.isAvailable()) {
      try {
        // Test that the OGR system is really setup.
        ogrHelper.getAvailableDrivers();
      } catch (NoClassDefFoundError e) {
        // A NoClassDefFoundError will be because the user has not copied the GDAL jar into RiskScape,
        // or maybe they have updated RiskScape and that has blown gdal.jar away
        throw new RiskscapeException(OgrProblems.get().gdalNotInstalled().withSeverity(Problem.Severity.FATAL));
      }
      engine.getBookmarkResolvers().add(new OgrResolver(engine, ogrHelper));
      engine.getBookmarkResolvers().add(new GdbResolver(engine, ogrHelper));
    }

    return problems;
  }

  @Override
  public void startUp(Map<String, List<String>> settings) throws PluginRuntimeException {
    super.startUp(settings);

    this.ogrHelper = new OgrHelper();
  }
}
