/*
 * RiskScape™ Copyright New Zealand Institute for Earth Science Limited
 * (Earth Sciences New Zealand) is distributed for research purposes only
 * under the terms of AGPLv3.
 *
 * RiskScape™ Copyright 2025 New Zealand Institute for Earth Science
 * Limited (Earth Sciences New Zealand). All rights reserved. Source code
 * available under the AGPLv3.
 * 
 * This program is free software: you can redistribute it and/or modify it under
 *  the terms of the GNU Affero General Public License as published by the Free
 *  Software Foundation, either version 3 of the License, or (at your option) any
 *  later version.
 * 
 * This program is distributed for RESEARCH PURPOSES ONLY, in the hope that it will
 * be useful for research and education initiatives.
 * 
 * If you are not a researcher, or you are a researcher who wishes to use this
 * program on terms other than AGPLv3 (including those who wish to restrict the
 * distribution of any source code created using this program), please contact:
 * https://riskscape.org.nz
 * 
 * This program is distributed WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Affero General Public License for more details.  You should have received a copy
 * of the GNU Affero General Public License along with this program.  If not, see
 * <http://www.gnu.org/licenses/>.
 * 
 * By way of summary only, under the AGPLv3:
 *     • Permissions of this strongest copyleft license are conditioned
 *       on making available complete source code of licensed works and
 *       modifications, which include larger works using a licensed work,
 *       under the same license.
 *     • Copyright and license notices must be preserved.
 *     • Contributors provide an express grant of patent rights.
 *     • When a modified version is used to provide a service over a
 *       network, the complete source code of the modified version must be made
 *       available.
 */
package nz.org.riskscape.jython;

import java.util.List;

import org.python.core.Py;
import org.python.core.PyObject;
import com.google.common.collect.Lists;

import nz.org.riskscape.engine.function.RiskscapeFunction;

@SuppressWarnings("serial")
public class NestedFunction extends PyObject implements JavaJythonHelpers {

  private RiskscapeFunction function;

  public NestedFunction(RiskscapeFunction function) {
    this.function = function;
  }

  @Override
  // CHECKSTYLE:OFF
  public PyObject __call__(PyObject[] args, String[] keywords) {
  // CHECKSTYLE:ON

    if (keywords.length > 0) {
      // TODO PyError
      throw new RuntimeException("keywords not supported");
    }

    if (args.length != function.getArgumentTypes().size()) {
      // TODO PyError
      throw new RuntimeException(String.format("Function %s expected %d args, got %d", function, args.length,
          function.getArgumentTypes().size()));
    }

    List<Object> convertedArgs = Lists.newArrayListWithCapacity(args.length);
    for (int i = 0; i < args.length; i++) {
      PyObject pyObject = args[i];
      convertedArgs.add(convertFromPython(pyObject, function.getArgumentTypes().get(i)));
    }

    return Py.java2py(function.getReturnType().coerce(function.call(convertedArgs)));
  }


  // kludge to allow syntax of functions['foo'].call(args) as well as
  // functions['foo'](args)
  public PyObject getCall() {
    return this;
  }
}
