# Hdf5 examples

These came from https://support.hdfgroup.org/ftp/HDF5/examples/files/exbyapi/

I have only included the examples that the tests actually use, but note that there 
are many more.

The `h5ex_d_combined.h5` file combined two example datasets into a single file using:

```
h5copy -i h5ex_d_rdwr.h5 -s /DS1 -o h5ex_d_combined.h5 -d /DS1
h5copy -i h5ex_d_transform.h5 -s /DS1 -o h5ex_d_combined.h5 -d /DS2
```

`h5ex_d_diffsizes.h5` is a combination of `h5ex_d_transform.h5` and `h5ex_d_hyper.h`.

The vlen floats example is a dump from a small probabilistic hdf5 openquake output.
Likewise, h5ex_t_1d_dataset.h5 was taken from calc_ses100.hdf5 using h5copy:

```
h5copy -i input.hdf5 -o h5ex_t_1d_dataset.h5 -s /events -d D1
```

## Using h5py

Files are also fairly easy to create in python using `h5py`. The `h5ex_t_att.h5` file was created using:

```
import h5py
f = h5py.File("mytestfile.hdf5", "w")
dset = f.create_dataset("DS1", (0,), dtype='i')
dset.attrs['INT'] = 42
dset.attrs['FLOAT'] = 3.50
group = f.create_group("G1")
group.attrs['FLOAT'] = 3.14
import numpy as np
group.attrs['TEXT'] = np.array('foo'.encode("latin-1"), dtype=h5py.string_dtype('ascii', 10))
f.close()
```
