/*
 * RiskScape™ Copyright New Zealand Institute for Earth Science Limited
 * (Earth Sciences New Zealand) is distributed for research purposes only
 * under the terms of AGPLv3.
 *
 * RiskScape™ Copyright 2025 New Zealand Institute for Earth Science
 * Limited (Earth Sciences New Zealand). All rights reserved. Source code
 * available under the AGPLv3.
 * 
 * This program is free software: you can redistribute it and/or modify it under
 *  the terms of the GNU Affero General Public License as published by the Free
 *  Software Foundation, either version 3 of the License, or (at your option) any
 *  later version.
 * 
 * This program is distributed for RESEARCH PURPOSES ONLY, in the hope that it will
 * be useful for research and education initiatives.
 * 
 * If you are not a researcher, or you are a researcher who wishes to use this
 * program on terms other than AGPLv3 (including those who wish to restrict the
 * distribution of any source code created using this program), please contact:
 * https://riskscape.org.nz
 * 
 * This program is distributed WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Affero General Public License for more details.  You should have received a copy
 * of the GNU Affero General Public License along with this program.  If not, see
 * <http://www.gnu.org/licenses/>.
 * 
 * By way of summary only, under the AGPLv3:
 *     • Permissions of this strongest copyleft license are conditioned
 *       on making available complete source code of licensed works and
 *       modifications, which include larger works using a licensed work,
 *       under the same license.
 *     • Copyright and license notices must be preserved.
 *     • Contributors provide an express grant of patent rights.
 *     • When a modified version is used to provide a service over a
 *       network, the complete source code of the modified version must be made
 *       available.
 */
package nz.org.riskscape.hdf5;

import java.nio.file.Path;
import java.nio.file.Paths;

import org.junit.After;
import org.junit.BeforeClass;
import org.junit.experimental.categories.Category;

import hdf.hdf5lib.H5;
import nz.org.riskscape.engine.ProjectTest;

@Category(H5TestMarker.class)
public class Hdf5BaseTest extends ProjectTest {

  protected final Path examplesDir = Paths.get("src", "test", "resources", "hdf5-examples");

  protected H5File example;

  protected H5Dataset dataset;

  @BeforeClass
  public static void setupH5Library() {
    if (System.getProperty(H5.H5PATH_PROPERTY_KEY) == null) {
      System.setProperty(H5.H5PATH_PROPERTY_KEY, "/opt/hdf5-1.12.2/lib/libhdf5_java.so");
    }
  }

  public H5File openFile(String file) {
    this.example = new H5File(examplesDir.resolve(file));
    return example;
  }

  public H5Dataset openDataset(String file, String datasetName) {
    this.dataset = openFile(file).openDataset("/", datasetName);
    return dataset;
  }

  @After
  public void closeExample() {
    if (example != null) {
      example.close();
    }
  }
}
