/*
 * RiskScape™ Copyright New Zealand Institute for Earth Science Limited
 * (Earth Sciences New Zealand) is distributed for research purposes only
 * under the terms of AGPLv3.
 *
 * RiskScape™ Copyright 2025 New Zealand Institute for Earth Science
 * Limited (Earth Sciences New Zealand). All rights reserved. Source code
 * available under the AGPLv3.
 * 
 * This program is free software: you can redistribute it and/or modify it under
 *  the terms of the GNU Affero General Public License as published by the Free
 *  Software Foundation, either version 3 of the License, or (at your option) any
 *  later version.
 * 
 * This program is distributed for RESEARCH PURPOSES ONLY, in the hope that it will
 * be useful for research and education initiatives.
 * 
 * If you are not a researcher, or you are a researcher who wishes to use this
 * program on terms other than AGPLv3 (including those who wish to restrict the
 * distribution of any source code created using this program), please contact:
 * https://riskscape.org.nz
 * 
 * This program is distributed WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Affero General Public License for more details.  You should have received a copy
 * of the GNU Affero General Public License along with this program.  If not, see
 * <http://www.gnu.org/licenses/>.
 * 
 * By way of summary only, under the AGPLv3:
 *     • Permissions of this strongest copyleft license are conditioned
 *       on making available complete source code of licensed works and
 *       modifications, which include larger works using a licensed work,
 *       under the same license.
 *     • Copyright and license notices must be preserved.
 *     • Contributors provide an express grant of patent rights.
 *     • When a modified version is used to provide a service over a
 *       network, the complete source code of the modified version must be made
 *       available.
 */
package nz.org.riskscape.hdf5.types;

import static hdf.hdf5lib.H5.*;

import java.nio.ByteBuffer;

import lombok.Getter;
import nz.org.riskscape.engine.types.RSList;
import nz.org.riskscape.engine.types.Type;

public class H5VlenType extends H5Type {

  @Getter
  private final H5Type memberType;

  protected H5VlenType(long id) {
    super(id);

    this.memberType = H5Type.build(H5Tget_super(id));
  }


  @Override
  public Type toType() {
    return RSList.create(memberType.toType());
  }

  @Override
  public Object read(ByteBuffer outBuf, int offset) {
    // we can't support this without further patching to the h5dread method to allow returning the `len,p` struct,
    // and then allow that to be returned as a special h5 object that allows lookup, but that could be potentially a
    // lot of jni calls and so a lot of overhead - OR we use good ol' unsafe and read the pointer directly
    throw new UnsupportedOperationException();
  }

  @Override
  public String toString() {
    return getClassName() + "(" + memberType.toString() + ")";
  }

  @Override
  public boolean isVariableLength() {
    return true;
  }

  // TODO to implement this, we'll need a new JNI call, as the only way to get the length is to cast the bytes to a
  // `hvl_` struct, which gives the length and a pointer to the vlen data
  //  public int getNumVLenElements() {

  @Override
  public void close() {
    super.close();
    this.memberType.close();
  }
}
