/*
 * RiskScape™ Copyright New Zealand Institute for Earth Science Limited
 * (Earth Sciences New Zealand) is distributed for research purposes only
 * under the terms of AGPLv3.
 *
 * RiskScape™ Copyright 2025 New Zealand Institute for Earth Science
 * Limited (Earth Sciences New Zealand). All rights reserved. Source code
 * available under the AGPLv3.
 * 
 * This program is free software: you can redistribute it and/or modify it under
 *  the terms of the GNU Affero General Public License as published by the Free
 *  Software Foundation, either version 3 of the License, or (at your option) any
 *  later version.
 * 
 * This program is distributed for RESEARCH PURPOSES ONLY, in the hope that it will
 * be useful for research and education initiatives.
 * 
 * If you are not a researcher, or you are a researcher who wishes to use this
 * program on terms other than AGPLv3 (including those who wish to restrict the
 * distribution of any source code created using this program), please contact:
 * https://riskscape.org.nz
 * 
 * This program is distributed WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Affero General Public License for more details.  You should have received a copy
 * of the GNU Affero General Public License along with this program.  If not, see
 * <http://www.gnu.org/licenses/>.
 * 
 * By way of summary only, under the AGPLv3:
 *     • Permissions of this strongest copyleft license are conditioned
 *       on making available complete source code of licensed works and
 *       modifications, which include larger works using a licensed work,
 *       under the same license.
 *     • Copyright and license notices must be preserved.
 *     • Contributors provide an express grant of patent rights.
 *     • When a modified version is used to provide a service over a
 *       network, the complete source code of the modified version must be made
 *       available.
 */
package nz.org.riskscape.engine.defaults.function;

import static org.junit.Assert.*;

import org.junit.Before;
import org.junit.Test;

import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.rl.BaseExpressionRealizerTest;
import nz.org.riskscape.engine.rl.LanguageFunctions;
import nz.org.riskscape.engine.types.Nullable;
import nz.org.riskscape.engine.types.Struct;

public class IsExposedTest extends BaseExpressionRealizerTest {

  Struct inputType = Struct.of("exposure", Nullable.ANYTHING,
      "hazard", Nullable.ANYTHING,
      "resource", Nullable.ANYTHING);

  @Before
  public void setup() {
    project.getFunctionSet().addAll(LanguageFunctions.FUNCTIONS);
    project.getFunctionSet().add(new IsExposed().asFunction().identified("is_exposed"));
  }

  @Test
  public void canExecuteWithExposureAndHazard() {
    assertEquals(1L, evaluate("is_exposed('foo', 'bar')", Tuple.EMPTY_TUPLE));
    // arg 1 is required so we get null-safe handling
    assertNull(evaluate("is_exposed(null_of('text'), 'bar')", Tuple.EMPTY_TUPLE));


    assertEquals(0L, evaluate("is_exposed('foo', null_of('text'))", Tuple.EMPTY_TUPLE));

    assertEquals(1L, evaluate("is_exposed(hazard: 'foo', exposure: 'bar')", Tuple.EMPTY_TUPLE));
    assertEquals(0L, evaluate("is_exposed(hazard: null_of('text'), exposure: 'bar')", Tuple.EMPTY_TUPLE));
  }

  @Test
  public void canExecuteWithExposureHazardAndResource() {
    assertEquals(1L, evaluate("is_exposed('foo', 'bar', 'baz')", Tuple.EMPTY_TUPLE));
    // arg 1 is required so we get null-safe handling
    assertNull(evaluate("is_exposed(null_of('text'), 'bar', 'baz')", Tuple.EMPTY_TUPLE));

    assertEquals(0L, evaluate("is_exposed('foo', null_of('text'), 'baz')", Tuple.EMPTY_TUPLE));

    assertEquals(1L, evaluate("is_exposed(hazard: 'foo', resource: 'bar', exposure: 'baz')", Tuple.EMPTY_TUPLE));
    assertEquals(1L, evaluate("is_exposed(hazard: 'foo', resource: null_of('text'), exposure: 'baz')",
        Tuple.EMPTY_TUPLE));
  }

}
