/*
 * RiskScape™ Copyright New Zealand Institute for Earth Science Limited
 * (Earth Sciences New Zealand) is distributed for research purposes only
 * under the terms of AGPLv3.
 *
 * RiskScape™ Copyright 2025 New Zealand Institute for Earth Science
 * Limited (Earth Sciences New Zealand). All rights reserved. Source code
 * available under the AGPLv3.
 * 
 * This program is free software: you can redistribute it and/or modify it under
 *  the terms of the GNU Affero General Public License as published by the Free
 *  Software Foundation, either version 3 of the License, or (at your option) any
 *  later version.
 * 
 * This program is distributed for RESEARCH PURPOSES ONLY, in the hope that it will
 * be useful for research and education initiatives.
 * 
 * If you are not a researcher, or you are a researcher who wishes to use this
 * program on terms other than AGPLv3 (including those who wish to restrict the
 * distribution of any source code created using this program), please contact:
 * https://riskscape.org.nz
 * 
 * This program is distributed WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Affero General Public License for more details.  You should have received a copy
 * of the GNU Affero General Public License along with this program.  If not, see
 * <http://www.gnu.org/licenses/>.
 * 
 * By way of summary only, under the AGPLv3:
 *     • Permissions of this strongest copyleft license are conditioned
 *       on making available complete source code of licensed works and
 *       modifications, which include larger works using a licensed work,
 *       under the same license.
 *     • Copyright and license notices must be preserved.
 *     • Contributors provide an express grant of patent rights.
 *     • When a modified version is used to provide a service over a
 *       network, the complete source code of the modified version must be made
 *       available.
 */
package nz.org.riskscape.engine.defaults.data;

import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Optional;
import java.util.function.Function;

import nz.org.riskscape.engine.Engine;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.data.BookmarkResolver;
import nz.org.riskscape.engine.output.Format;
import nz.org.riskscape.engine.output.RiskscapeWriter;
import nz.org.riskscape.engine.resource.CreateHandle;
import nz.org.riskscape.engine.resource.FileCreateHandle;

/**
 * Base class for format integration tests. That is tests that check that RiskScape can read a file
 * that it has written and vice versa.
 */
public class BaseFormatIntegrationTest extends BaseBookmarkResolverTest {

  private final Format format;
  private final Path tempDirectory;

  public BaseFormatIntegrationTest(Format format, Function<Engine, BookmarkResolver> resolverBuilder) {
    super("kml", resolverBuilder);
    this.format = format;
    try {
      tempDirectory = Files.createTempDirectory(getClass().getSimpleName());
    } catch (IOException e) {
      throw new RuntimeException(e);
    }
  }

  protected URI write(Tuple... values) {
    try {
      CreateHandle handle = new FileCreateHandle(null,
          Files.createTempFile(tempDirectory, "output", "." + format.getExtension()).toFile());
      RiskscapeWriter writer = format.getWriterConstructor().get()
          .newWriter(executionContext, values[0].getStruct(), handle, Optional.empty()).get();
      for (Tuple value : values) {
        writer.write(value);
      }
      writer.close();
      return writer.getStoredAt();
    } catch (IOException e) {
      throw new RuntimeException(e);
    }
  }

}
