/*
 * RiskScape™ Copyright New Zealand Institute for Earth Science Limited
 * (Earth Sciences New Zealand) is distributed for research purposes only
 * under the terms of AGPLv3.
 *
 * RiskScape™ Copyright 2025 New Zealand Institute for Earth Science
 * Limited (Earth Sciences New Zealand). All rights reserved. Source code
 * available under the AGPLv3.
 * 
 * This program is free software: you can redistribute it and/or modify it under
 *  the terms of the GNU Affero General Public License as published by the Free
 *  Software Foundation, either version 3 of the License, or (at your option) any
 *  later version.
 * 
 * This program is distributed for RESEARCH PURPOSES ONLY, in the hope that it will
 * be useful for research and education initiatives.
 * 
 * If you are not a researcher, or you are a researcher who wishes to use this
 * program on terms other than AGPLv3 (including those who wish to restrict the
 * distribution of any source code created using this program), please contact:
 * https://riskscape.org.nz
 * 
 * This program is distributed WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Affero General Public License for more details.  You should have received a copy
 * of the GNU Affero General Public License along with this program.  If not, see
 * <http://www.gnu.org/licenses/>.
 * 
 * By way of summary only, under the AGPLv3:
 *     • Permissions of this strongest copyleft license are conditioned
 *       on making available complete source code of licensed works and
 *       modifications, which include larger works using a licensed work,
 *       under the same license.
 *     • Copyright and license notices must be preserved.
 *     • Contributors provide an express grant of patent rights.
 *     • When a modified version is used to provide a service over a
 *       network, the complete source code of the modified version must be made
 *       available.
 */
package nz.org.riskscape.defaults.interp;

import static org.hamcrest.Matchers.*;

import org.junit.Test;

import static org.junit.Assert.*;

import nz.org.riskscape.engine.util.Pair;


public class BilinearContinuousFunctionTypeTest {

  @Test
  public void getsPointsSurrounding() {
    double[] values = new double[]{2D, 4D, 6D, 8D};

    // too low returns first point
    assertThat(BilinearContinuousFunctionType.surrounding(0D, values), is(Pair.of(2D, 2D)));
    assertThat(BilinearContinuousFunctionType.surrounding(1D, values), is(Pair.of(2D, 2D)));
    assertThat(BilinearContinuousFunctionType.surrounding(1.99D, values), is(Pair.of(2D, 2D)));

    // too high returns last point
    assertThat(BilinearContinuousFunctionType.surrounding(8.1D, values), is(Pair.of(8D, 8D)));
    assertThat(BilinearContinuousFunctionType.surrounding(10D, values), is(Pair.of(8D, 8D)));
    assertThat(BilinearContinuousFunctionType.surrounding(100D, values), is(Pair.of(8D, 8D)));

    // exact match on points
    assertThat(BilinearContinuousFunctionType.surrounding(2D, values), is(Pair.of(2D, 2D)));
    assertThat(BilinearContinuousFunctionType.surrounding(4D, values), is(Pair.of(4D, 4D)));
    assertThat(BilinearContinuousFunctionType.surrounding(6D, values), is(Pair.of(6D, 6D)));
    assertThat(BilinearContinuousFunctionType.surrounding(8D, values), is(Pair.of(8D, 8D)));

    // points between
    assertThat(BilinearContinuousFunctionType.surrounding(2.1D, values), is(Pair.of(2D, 4D)));
    assertThat(BilinearContinuousFunctionType.surrounding(3D, values), is(Pair.of(2D, 4D)));
    assertThat(BilinearContinuousFunctionType.surrounding(3.99D, values), is(Pair.of(2D, 4D)));

    assertThat(BilinearContinuousFunctionType.surrounding(4.1D, values), is(Pair.of(4D, 6D)));
    assertThat(BilinearContinuousFunctionType.surrounding(5.9D, values), is(Pair.of(4D, 6D)));


    assertThat(BilinearContinuousFunctionType.surrounding(6.1D, values), is(Pair.of(6D, 8D)));
    assertThat(BilinearContinuousFunctionType.surrounding(7.9D, values), is(Pair.of(6D, 8D)));
  }

}
