/*
 * RiskScape™ Copyright New Zealand Institute for Earth Science Limited
 * (Earth Sciences New Zealand) is distributed for research purposes only
 * under the terms of AGPLv3.
 *
 * RiskScape™ Copyright 2025 New Zealand Institute for Earth Science
 * Limited (Earth Sciences New Zealand). All rights reserved. Source code
 * available under the AGPLv3.
 * 
 * This program is free software: you can redistribute it and/or modify it under
 *  the terms of the GNU Affero General Public License as published by the Free
 *  Software Foundation, either version 3 of the License, or (at your option) any
 *  later version.
 * 
 * This program is distributed for RESEARCH PURPOSES ONLY, in the hope that it will
 * be useful for research and education initiatives.
 * 
 * If you are not a researcher, or you are a researcher who wishes to use this
 * program on terms other than AGPLv3 (including those who wish to restrict the
 * distribution of any source code created using this program), please contact:
 * https://riskscape.org.nz
 * 
 * This program is distributed WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Affero General Public License for more details.  You should have received a copy
 * of the GNU Affero General Public License along with this program.  If not, see
 * <http://www.gnu.org/licenses/>.
 * 
 * By way of summary only, under the AGPLv3:
 *     • Permissions of this strongest copyleft license are conditioned
 *       on making available complete source code of licensed works and
 *       modifications, which include larger works using a licensed work,
 *       under the same license.
 *     • Copyright and license notices must be preserved.
 *     • Contributors provide an express grant of patent rights.
 *     • When a modified version is used to provide a service over a
 *       network, the complete source code of the modified version must be made
 *       available.
 */
package nz.org.riskscape.defaults.curves;

import static org.junit.Assert.*;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Test;

import com.google.common.collect.Lists;

import lombok.Getter;

public class LinearFitterTest extends BaseCurveFitterTest {

  @Getter
  LinearFitter fitter = new LinearFitter();

  @Test
  public void testBasicLinearFit() {
    // a set of points that are on a straight line
    xValues.addAll(Lists.newArrayList(50D, 100D, 150D, 200D));
    yValues.addAll(Lists.newArrayList(50D, 100D, 150D, 200D));

    fit();

    // I thought we would have got exact values out but that doesn't seem to happen. So lets verify we
    // are close enough.
    assertThat(interpolate(100D), closeTo(100D));
    assertThat(interpolate(200D), closeTo(200D));
    assertThat(interpolate(300D), closeTo(300D));
    assertThat(interpolate(1000D), closeTo(1000D));

    assertThat(interpolate(0D), closeTo(0D));
    assertThat(interpolate(-1000D), closeTo(-1000D));
  }

  @Test
  public void testLinearFitWithAScatteringOfPoints() {
    // the points are scattered in a balanced way on either side of the expected 45 degree line
    xValues.addAll(Lists.newArrayList(50D, 50D, 100D, 140D, 160D, 200D, 200D));
    yValues.addAll(Lists.newArrayList(30D, 70D, 100D, 140D, 160D, 180D, 220D));

    fit();

    // I thought we would have got exact values out but that doesn't seem to happen. So lets verify we
    // are close enough.
    assertThat(interpolate(100D), closeTo(100D));
    assertThat(interpolate(200D), closeTo(200D));
    assertThat(interpolate(300D), closeTo(300D));
    assertThat(interpolate(1000D), closeTo(1000D));

    assertThat(interpolate(0D), closeTo(0D));
    assertThat(interpolate(-1000D), closeTo(-1000D));
  }

  Matcher<Double> closeTo(Double y) {
    return Matchers.closeTo(y, 0.00001);
  }

}
