/*
 * RiskScape™ Copyright New Zealand Institute for Earth Science Limited
 * (Earth Sciences New Zealand) is distributed for research purposes only
 * under the terms of AGPLv3.
 *
 * RiskScape™ Copyright 2025 New Zealand Institute for Earth Science
 * Limited (Earth Sciences New Zealand). All rights reserved. Source code
 * available under the AGPLv3.
 * 
 * This program is free software: you can redistribute it and/or modify it under
 *  the terms of the GNU Affero General Public License as published by the Free
 *  Software Foundation, either version 3 of the License, or (at your option) any
 *  later version.
 * 
 * This program is distributed for RESEARCH PURPOSES ONLY, in the hope that it will
 * be useful for research and education initiatives.
 * 
 * If you are not a researcher, or you are a researcher who wishes to use this
 * program on terms other than AGPLv3 (including those who wish to restrict the
 * distribution of any source code created using this program), please contact:
 * https://riskscape.org.nz
 * 
 * This program is distributed WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Affero General Public License for more details.  You should have received a copy
 * of the GNU Affero General Public License along with this program.  If not, see
 * <http://www.gnu.org/licenses/>.
 * 
 * By way of summary only, under the AGPLv3:
 *     • Permissions of this strongest copyleft license are conditioned
 *       on making available complete source code of licensed works and
 *       modifications, which include larger works using a licensed work,
 *       under the same license.
 *     • Copyright and license notices must be preserved.
 *     • Contributors provide an express grant of patent rights.
 *     • When a modified version is used to provide a service over a
 *       network, the complete source code of the modified version must be made
 *       available.
 */
package nz.org.riskscape.defaults.auth;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.*;
import static org.junit.Assert.*;

import java.util.Base64;

import org.junit.Test;

import nz.org.riskscape.engine.auth.HttpSecretTest;
import nz.org.riskscape.engine.auth.SecretBuilder;
import nz.org.riskscape.engine.util.Pair;

public class PlatformSecretTest extends HttpSecretTest<PlatformSecret> {

  String expectedBase64 = Base64.getEncoder().encodeToString("TOKEN:shhhhh!".getBytes());

  public PlatformSecretTest() {
    // should be set by default
    params.remove("hostname");
    // set a token
    params.put("token", "shhhhh!");
  }

  @Override
  public SecretBuilder getSecretBuilder() {
    return PlatformSecret.BUILDER;
  }

  @Override
  protected String getSecretValue() {
    return secret.getToken();
  }

  @Test
  public void secretHasExpectedValues() {
    buildSecret();

    assertThat(secret.getId(), is("foo"));
    assertThat(secret.getHostname(), is("riskscape.nz"));
    assertThat(secret.getToken(), is("shhhhh!"));

    applySecret("https://riskscape.nz");

    assertThat(request.getHeaders(), contains(
        // automatically does the base64 magic
        is(Pair.of("Authorization", "Basic " + expectedBase64))
    ));
  }

  @Test
  public void canOverrideTheHostname() throws Exception {
    params.put("hostname", "platform-test.ci.rsdev.nz");

    buildSecret();

    assertThat(secret.getHostname(), equalTo("platform-test.ci.rsdev.nz"));

    applySecret("https://platform-test.ci.rsdev.nz/foo");

    assertThat(request.getHeaders(), contains(
        // automatically does the base64 magic
        is(Pair.of("Authorization", "Basic " + expectedBase64))
    ));

    // it won't apply to the default hostname
    applySecret("https://riskscape.nz/foo");
    assertFalse(request.isSecretApplied());
  }
}
