/*
 * RiskScape™ Copyright New Zealand Institute for Earth Science Limited
 * (Earth Sciences New Zealand) is distributed for research purposes only
 * under the terms of AGPLv3.
 *
 * RiskScape™ Copyright 2025 New Zealand Institute for Earth Science
 * Limited (Earth Sciences New Zealand). All rights reserved. Source code
 * available under the AGPLv3.
 * 
 * This program is free software: you can redistribute it and/or modify it under
 *  the terms of the GNU Affero General Public License as published by the Free
 *  Software Foundation, either version 3 of the License, or (at your option) any
 *  later version.
 * 
 * This program is distributed for RESEARCH PURPOSES ONLY, in the hope that it will
 * be useful for research and education initiatives.
 * 
 * If you are not a researcher, or you are a researcher who wishes to use this
 * program on terms other than AGPLv3 (including those who wish to restrict the
 * distribution of any source code created using this program), please contact:
 * https://riskscape.org.nz
 * 
 * This program is distributed WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Affero General Public License for more details.  You should have received a copy
 * of the GNU Affero General Public License along with this program.  If not, see
 * <http://www.gnu.org/licenses/>.
 * 
 * By way of summary only, under the AGPLv3:
 *     • Permissions of this strongest copyleft license are conditioned
 *       on making available complete source code of licensed works and
 *       modifications, which include larger works using a licensed work,
 *       under the same license.
 *     • Copyright and license notices must be preserved.
 *     • Contributors provide an express grant of patent rights.
 *     • When a modified version is used to provide a service over a
 *       network, the complete source code of the modified version must be made
 *       available.
 */
package nz.org.riskscape.defaults.curves;

import nz.org.riskscape.engine.function.RiskscapeFunction;
import nz.org.riskscape.engine.function.UntypedFunction;

/**
 * The results of a curve fitting operation, aka {@link CurveFitter#fit(Object parameters, ObservedPoints points)}
 * Can be used to yield a function and get various metadata about the fit itself.
 */
public interface FitCurve<T> {

  /**
   * @return the thing that produced this fit
   */
  CurveFitter<T> getFitter();

  /**
   * @return the untyped part of a {@link RiskscapeFunction} that can be used to compute `f(x) = y`, should accept
   * and return doubles.
   *
   */
  UntypedFunction getFunction();

  /**
   * @return that dataset that was used to fit this curve
   */
  ObservedPoints getObservedPoints();

  /**
   * @return the parameters, specific to each type of function, that were produced when this function was fit
   */
  T getFitParameters();

  /**
   * @return an `r²` value for this curve against the original data points
   */
  double getFitScore();

  // TODO add a function that can compute or estimate the area under the fit curve - current approach is to just use
  // trapezoid, but we can probably return a fit-for-purpose function depending on the type of curve, falling back to
  // trapezoid if nothing better exists.
  //UntypedFunction getIntegrationFunction();

}
