/*
 * RiskScape™ Copyright New Zealand Institute for Earth Science Limited
 * (Earth Sciences New Zealand) is distributed for research purposes only
 * under the terms of AGPLv3.
 *
 * RiskScape™ Copyright 2025 New Zealand Institute for Earth Science
 * Limited (Earth Sciences New Zealand). All rights reserved. Source code
 * available under the AGPLv3.
 * 
 * This program is free software: you can redistribute it and/or modify it under
 *  the terms of the GNU Affero General Public License as published by the Free
 *  Software Foundation, either version 3 of the License, or (at your option) any
 *  later version.
 * 
 * This program is distributed for RESEARCH PURPOSES ONLY, in the hope that it will
 * be useful for research and education initiatives.
 * 
 * If you are not a researcher, or you are a researcher who wishes to use this
 * program on terms other than AGPLv3 (including those who wish to restrict the
 * distribution of any source code created using this program), please contact:
 * https://riskscape.org.nz
 * 
 * This program is distributed WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Affero General Public License for more details.  You should have received a copy
 * of the GNU Affero General Public License along with this program.  If not, see
 * <http://www.gnu.org/licenses/>.
 * 
 * By way of summary only, under the AGPLv3:
 *     • Permissions of this strongest copyleft license are conditioned
 *       on making available complete source code of licensed works and
 *       modifications, which include larger works using a licensed work,
 *       under the same license.
 *     • Copyright and license notices must be preserved.
 *     • Contributors provide an express grant of patent rights.
 *     • When a modified version is used to provide a service over a
 *       network, the complete source code of the modified version must be made
 *       available.
 */
package nz.org.riskscape.defaults.classifier;

import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.problem.ProblemCode;

public enum ProblemCodes implements ProblemCode {

  /**
   * When a classifier function pre section does not return a struct type.
   */
  PRE_NOT_STRUCT,
  /**
   * When a classifier function body section does not return a struct type. which is required if
   * there is a post section
   */
  BODY_NOT_STRUCT,
  /**
   * Classifier function is missing an id
   */
  MISSING_ID,
  /**
   * Classifier function has an empty body
   */
  EMPTY_BODY,
  /**
   * When a filter has no content. Requires either child filters or a function.
   */
  EMPTY_FILTER,

  /**
   * When the declared return-type doesn't match what's actually returned by the post/etc
   */
  RETURN_TYPE_MISMATCH,

  /**
   * When some {@link RealizedTreeExpression}s return simple types whilst others return {@link Struct}
   * types.
   */
  MIXED_TREE_RESULT_TYPES,

  /**
   * When both a function and a default is supplied. This is not allowed as the function becomes
   * the default if no default is supplied. When this occurs the function itself becomes redundant
   * which is not likely to be what the user expects.
   */
  FUNCTION_AND_DEFAULT,

  /**
   * When the identifier has already been defined. Re-using the same ident is not allowed.
   */
  REDEFINITION;

}
