import pandas

def compute_aal(df, parameters):
    df['expected_loss'] = df[parameters['probability']] * df[parameters['loss']]
    return df['expected_loss'].sum()

def function(rows, parameters={'probability': 'probability', 'loss': 'loss'}):
    df = pandas.DataFrame(rows)
    aal = compute_aal(df, parameters)

    yield {'aal': aal}
