import pandas
# same as pandas-aal.py but the pipeline step MUST always specify parameters

def compute_aal(df, parameters):
    df['expected_loss'] = df[parameters['probability']] * df[parameters['loss']]
    return df['expected_loss'].sum()

def function(rows, parameters):
    df = pandas.DataFrame(rows)
    aal = compute_aal(df, parameters)

    yield {'aal': aal}
