def function(road, flood):
  surface_type = road['surface_type']

  accumulated_damage = 0.0
  for moment in flood:
    velocity = moment['velocity']

    if road['surface_type'] == 'gravel':
      accumulated_damage += 0.1 * velocity
    elif road['surface_type'] == 'asphalt':
      accumulated_damage += 0.01
    else:
      accumulated_damage += 0.2 * velocity

  # We print out two lines to check the console output is similiarly split up
  print("Surface type was %s" % surface_type)
  print("Damage was %s" % round(accumulated_damage, 2))

  return min(1.0, accumulated_damage)
