
from nz.org.riskscape.engine.types import Struct, Anything, Text

ID = 'simple:struct'
DESCRIPTION = "This is function that returns loss as a struct"

ARGUMENT_TYPES = ['asset:simple:anything', 'hazard:simple:anything']

# for now, we will instantiate this directly, but we probably want this to be declared as a string, e.g.
# riskscape:some-loss
RETURN_TYPE = Struct.StructBuilder() \
    .and("loss1", Text()) \
    .and("loss2", Anything()) \
    .build()

def function(asset, hazard):
  result = {}
  result["loss1"] = "{0}".format(hazard.value)
  result["loss2"] = "{0} {0}".format(hazard.value)
  return result
