/*
 * RiskScape™ Copyright New Zealand Institute for Earth Science Limited
 * (Earth Sciences New Zealand) is distributed for research purposes only
 * under the terms of AGPLv3.
 *
 * RiskScape™ Copyright 2025 New Zealand Institute for Earth Science
 * Limited (Earth Sciences New Zealand). All rights reserved. Source code
 * available under the AGPLv3.
 * 
 * This program is free software: you can redistribute it and/or modify it under
 *  the terms of the GNU Affero General Public License as published by the Free
 *  Software Foundation, either version 3 of the License, or (at your option) any
 *  later version.
 * 
 * This program is distributed for RESEARCH PURPOSES ONLY, in the hope that it will
 * be useful for research and education initiatives.
 * 
 * If you are not a researcher, or you are a researcher who wishes to use this
 * program on terms other than AGPLv3 (including those who wish to restrict the
 * distribution of any source code created using this program), please contact:
 * https://riskscape.org.nz
 * 
 * This program is distributed WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Affero General Public License for more details.  You should have received a copy
 * of the GNU Affero General Public License along with this program.  If not, see
 * <http://www.gnu.org/licenses/>.
 * 
 * By way of summary only, under the AGPLv3:
 *     • Permissions of this strongest copyleft license are conditioned
 *       on making available complete source code of licensed works and
 *       modifications, which include larger works using a licensed work,
 *       under the same license.
 *     • Copyright and license notices must be preserved.
 *     • Contributors provide an express grant of patent rights.
 *     • When a modified version is used to provide a service over a
 *       network, the complete source code of the modified version must be made
 *       available.
 */
package nz.org.riskscape.test;

import java.nio.file.Path;
import java.nio.file.Paths;
import static junit.framework.Assert.assertEquals;
import nz.org.riskscape.engine.cli.BaseCliIntegrationTest2;
import nz.org.riskscape.engine.cli.CommandResult;
import static org.junit.Assert.assertThat;
import static org.hamcrest.Matchers.*;
import org.junit.Test;

public class Test_Kaiju_Attacks extends BaseCliIntegrationTest2 {

  @Override
  protected Path homeDir() {
    //Check for a system property indicating where the kaiju home directory is.
    //This allows for easier customisation via project properties in the gradle build.
    String kaijuHome = System.getProperty("Kaiju_Home");
    if (kaijuHome != null) {
      return Paths.get(kaijuHome);
    }
    //Defaults to known relative path in Risksacpe Project.
    return environment().sourceTree.resolve("..").resolve("kaiju");
  }

  @Test
  public void canListKaijuTypes() {
    CommandResult result = runner.execute(defaultCommand().subcommand("type").subcommand("list"));
    assertEquals(new Integer(0), result.exitCode);
  }

  @Test
  public void canRunAttackModel() {
    CommandResult result = runner.execute(defaultCommand().subcommand("model").subcommand("run")
        .option("kaiju:stomp")
        .option("--outfile", "-")
        .option("--format", "json"));
    assertEquals(new Integer(0), result.exitCode);
    // assert we got the results we expected
    assertThat(result.stdout, hasItems(
        allOf(containsString("Statue of Liberty"), containsString("\"damage\":42"),
            containsString("\"hazard\":{\"geom\":"))
        // and so on...
    ));
  }

}
