import Samoa_Building_Fragility
import random

def function(building, hazard_depth):
    if hazard_depth is None:
        return '0: Not damaged'

    # seed the random number generation so that we get consistent results across model runs
    random.seed(str(building) + str(hazard_depth))

    probability = Samoa_Building_Fragility.function(building, hazard_depth)

    # randomly assign a damage state based on the probabilities, i.e. likelihood of being in
    # one damage state and not others. (Having a concrete damage state makes the example
    # a little easier to understand, rather than having 5 different DS probabilities)
    return random.choices(['0: Not damaged',
                           '1: Light',
                           '2: Minor',
                           '3: Moderate',
                           '4: Severe',
                           '5: Collapse'],
                           weights=[1.0 - probability['DS_1'],
                                    probability['DS_1'] - probability['DS_2'],
                                    probability['DS_2'] - probability['DS_3'],
                                    probability['DS_3'] - probability['DS_4'],
                                    probability['DS_4'] - probability['DS_5'],
                                    probability['DS_5']])[0]
