from nz.org.riskscape.engine.types import Nullable

ID = 'kaiju_stomp_scorch'
DESCRIPTION = 'Models damage from a Kaiju stomping and/or scorching a building'

ARGUMENT_TYPES = ['building', Nullable.of(typeset.getLinkedType('kaiju_attack')), \
 Nullable.of(typeset.getLinkedType('kaiju_attack'))]

RETURN_TYPE = 'building_attack_outcome'

def function(building, stomp, scorch):
    if stomp is None and scorch is None:
        stomp_severity = 0
        scorch_severity = 0
    else:
        if stomp is None:
            stomp_severity = 1 #needs to be 1 to not reduce scorch losses
        else:
            stomp_severity = stomp.get('severity')

        if scorch is None:
            scorch_severity = 1 #needs to be 1 to not reduce stomp losses
        else:
            scorch_severity = scorch.get('severity')

    if building.get('construction') == 'timber':
        resilience = 1
    elif building.get('construction') == 'concrete':
        resilience = 5
    elif building.get('construction') == 'steel':
        resilience = 5
    else:
        resilience = 4

    damage = (10 - resilience) * stomp_severity * scorch_severity
    if damage > 100:
        damage = 100
    return {
        'damage': damage
    }
