from nz.org.riskscape.engine.types import Nullable
from nz.org.riskscape.engine.function import DiscreteFunction

ID = 'kaiju_building_attack'
DESCRIPTION = 'Losses from mythical kaiju attack on a building'

ARGUMENT_TYPES = ['building', Nullable.of(typeset.getLinkedType('kaiju_attack'))]
RETURN_TYPE = 'building_attack_outcome'

DAMAGE_CURVES = {
  'timber':   nested_function(DiscreteFunction.builder()  \
                .addPoint(0, 0) \
                .addPoint(10, 1) \
                .withLinearInterpolation() \
                .build()),
  'concrete': nested_function(DiscreteFunction.builder()  \
                .addPoint(0, 0) \
                .addPoint(10, 0.5) \
                .withLinearInterpolation() \
                .build()),
  'steel':    nested_function(DiscreteFunction.builder()  \
                .addPoint(0, 0) \
                .addPoint(10, 0.8) \
                .withLinearInterpolation() \
                .build())
}

def function(building, attack):
  if attack is None:
    return 0
  # Get the damage curve for the construction type
  dc = DAMAGE_CURVES[building.get('construction')]
  # apply the curve to attack severity and return result
  return dc.call(attack.get('severity'))
